/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.governance.core.yaml.swapper.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.auth.yaml.config.YamlAuthenticationConfiguration;
import org.apache.shardingsphere.infra.auth.yaml.swapper.AuthenticationYamlSwapper;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.yaml.config.YamlRootRuleConfigurations;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.replicaquery.api.config.ReplicaQueryRuleConfiguration;

public final class ConfigurationYamlConverter {
    public static Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String data) {
        Map result = YamlEngine.unmarshal((String)data);
        Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for governance.");
        return Maps.transformValues((Map)result, arg_0 -> ((DataSourceConfigurationYamlSwapper)new DataSourceConfigurationYamlSwapper()).swapToObject(arg_0));
    }

    public static Collection<RuleConfiguration> loadRuleConfigurations(String data) {
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(((YamlRootRuleConfigurations)YamlEngine.unmarshal((String)data, YamlRootRuleConfigurations.class)).getRules());
    }

    public static ReplicaQueryRuleConfiguration loadPrimaryReplicaRuleConfiguration(String data) {
        Collection<RuleConfiguration> ruleConfigurations = ConfigurationYamlConverter.loadRuleConfigurations(data);
        Optional<ReplicaQueryRuleConfiguration> result = ruleConfigurations.stream().filter(each -> each instanceof ReplicaQueryRuleConfiguration).map(ruleConfiguration -> (ReplicaQueryRuleConfiguration)ruleConfiguration).findFirst();
        Preconditions.checkState((boolean)result.isPresent());
        return result.get();
    }

    public static Authentication loadAuthentication(String data) {
        return new AuthenticationYamlSwapper().swapToObject((YamlAuthenticationConfiguration)YamlEngine.unmarshal((String)data, YamlAuthenticationConfiguration.class));
    }

    public static Properties loadProperties(String data) {
        return YamlEngine.unmarshalProperties((String)data);
    }

    private ConfigurationYamlConverter() {
    }
}

