/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import com.google.common.base.Strings;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.GovernanceRepository;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceCenterConfiguration;
import org.apache.shardingsphere.governance.repository.etcd.EtcdRepository;
import org.apache.shardingsphere.governance.repository.zookeeper.CuratorZookeeperRepository;
import org.apache.shardingsphere.ui.common.constant.InstanceType;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;

public final class CenterRepositoryFactory {
    private static final ConcurrentHashMap<String, RegistryRepository> REGISTRY_REPOSITORY_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ConfigurationRepository> CONFIG_REPOSITORY_MAP = new ConcurrentHashMap();

    public static RegistryRepository createRegistryRepository(CenterConfig config) {
        RegistryRepository result = REGISTRY_REPOSITORY_MAP.get(config.getName());
        if (null != result) {
            return result;
        }
        result = (RegistryRepository)CenterRepositoryFactory.createGovernanceRepository(config.getInstanceType());
        result.init(config.getGovernanceName(), CenterRepositoryFactory.convert(config));
        REGISTRY_REPOSITORY_MAP.put(config.getName(), result);
        return result;
    }

    public static ConfigurationRepository createConfigurationRepository(CenterConfig config) {
        ConfigurationRepository result = CONFIG_REPOSITORY_MAP.get(config.getName());
        if (null != result) {
            return result;
        }
        if (!Strings.isNullOrEmpty((String)config.getAdditionalConfigCenterServerList()) && !Strings.isNullOrEmpty((String)config.getAdditionalConfigCenterType())) {
            result = (ConfigurationRepository)CenterRepositoryFactory.createGovernanceRepository(config.getAdditionalConfigCenterType());
        } else {
            RegistryRepository registryRepository = (RegistryRepository)CenterRepositoryFactory.createGovernanceRepository(config.getInstanceType());
            if (registryRepository instanceof ConfigurationRepository) {
                result = (ConfigurationRepository)registryRepository;
            } else {
                throw new IllegalArgumentException("Registry repository is not suitable for config center and no additional config center configuration provided.");
            }
        }
        result.init(config.getGovernanceName(), CenterRepositoryFactory.convert(config));
        CONFIG_REPOSITORY_MAP.put(config.getName(), result);
        return result;
    }

    private static GovernanceCenterConfiguration convert(CenterConfig config) {
        GovernanceCenterConfiguration result = new GovernanceCenterConfiguration(config.getInstanceType(), config.getServerLists(), new Properties());
        result.getProps().put("digest", config.getDigest());
        return result;
    }

    private static GovernanceRepository createGovernanceRepository(String instanceType) {
        CuratorZookeeperRepository result;
        InstanceType type = InstanceType.nameOf(instanceType);
        switch (type) {
            case ZOOKEEPER: {
                result = new CuratorZookeeperRepository();
                break;
            }
            case ETCD: {
                EtcdRepository etcdCenterRepository = new EtcdRepository();
                etcdCenterRepository.setProps(new Properties());
                result = etcdCenterRepository;
                break;
            }
            default: {
                throw new UnsupportedOperationException(instanceType);
            }
        }
        return result;
    }

    private CenterRepositoryFactory() {
    }
}

