/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shardingsphere.governance.core.registry.RegistryCenterNodeStatus;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.ReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.ui.common.dto.InstanceDTO;
import org.apache.shardingsphere.ui.common.dto.ReplicaDataSourceDTO;
import org.apache.shardingsphere.ui.servcie.GovernanceService;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingSchemaService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.springframework.stereotype.Service;

@Service
public final class GovernanceServiceImpl
implements GovernanceService {
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource
    private ShardingSchemaService shardingSchemaService;

    @Override
    public Collection<InstanceDTO> getALLInstance() {
        List instanceIds = this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.getInstancesNodeFullRootPath());
        ArrayList<InstanceDTO> result = new ArrayList<InstanceDTO>(instanceIds.size());
        for (String instanceId : instanceIds) {
            String value = this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivatedStateNode().getProxyNodePath(instanceId));
            result.add(new InstanceDTO(instanceId, !RegistryCenterNodeStatus.DISABLED.toString().equalsIgnoreCase(value)));
        }
        return result;
    }

    @Override
    public void updateInstanceStatus(String instanceId, boolean enabled) {
        String value = enabled ? "" : RegistryCenterNodeStatus.DISABLED.toString();
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivatedStateNode().getProxyNodePath(instanceId), value);
    }

    @Override
    public Collection<ReplicaDataSourceDTO> getAllReplicaDataSource() {
        ArrayList<ReplicaDataSourceDTO> result = new ArrayList<ReplicaDataSourceDTO>();
        for (String schemaName : this.shardingSchemaService.getAllSchemaNames()) {
            String configData = this.shardingSchemaService.getRuleConfiguration(schemaName);
            if (configData.contains("!SHARDING")) {
                this.handleShardingRuleConfiguration(result, configData, schemaName);
                continue;
            }
            if (!configData.contains("!REPLICA_QUERY")) continue;
            this.handleMasterSlaveRuleConfiguration(result, configData, schemaName);
        }
        return result;
    }

    @Override
    public void updateReplicaDataSourceStatus(String schemaNames, String replicaDataSourceName, boolean enabled) {
        String value = enabled ? "" : RegistryCenterNodeStatus.DISABLED.toString();
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivatedStateNode().getDataSourcePath(schemaNames, replicaDataSourceName), value);
    }

    private String getInstancesNodeFullRootPath() {
        String result = this.registryCenterService.getActivatedStateNode().getProxyNodePath("");
        return result.substring(0, result.length() - 1);
    }

    private void handleShardingRuleConfiguration(Collection<ReplicaDataSourceDTO> replicaDataSourceDTOS, String configData, String schemaName) {
        Collection<RuleConfiguration> configurations = ConfigurationYamlConverter.loadRuleConfigurations(configData);
        Collection replicaQueryRuleConfigurations = configurations.stream().filter(config -> config instanceof ReplicaQueryRuleConfiguration).map(config -> (ReplicaQueryRuleConfiguration)config).collect(Collectors.toList());
        for (ReplicaQueryRuleConfiguration replicaQueryRuleConfiguration : replicaQueryRuleConfigurations) {
            this.addSlaveDataSource(replicaDataSourceDTOS, replicaQueryRuleConfiguration, schemaName);
        }
    }

    private void handleMasterSlaveRuleConfiguration(Collection<ReplicaDataSourceDTO> replicaDataSourceDTOS, String configData, String schemaName) {
        ReplicaQueryRuleConfiguration replicaQueryRuleConfiguration = ConfigurationYamlConverter.loadPrimaryReplicaRuleConfiguration(configData);
        this.addSlaveDataSource(replicaDataSourceDTOS, replicaQueryRuleConfiguration, schemaName);
    }

    private void addSlaveDataSource(Collection<ReplicaDataSourceDTO> replicaDataSourceDTOS, ReplicaQueryRuleConfiguration replicaQueryRuleConfiguration, String schemaName) {
        Collection<String> disabledSchemaDataSourceNames = this.getDisabledSchemaDataSourceNames();
        for (ReplicaQueryDataSourceRuleConfiguration each : replicaQueryRuleConfiguration.getDataSources()) {
            replicaDataSourceDTOS.addAll(this.getReplicaDataSourceDTOS(schemaName, disabledSchemaDataSourceNames, each));
        }
    }

    private Collection<ReplicaDataSourceDTO> getReplicaDataSourceDTOS(String schemaName, Collection<String> disabledSchemaDataSourceNames, ReplicaQueryDataSourceRuleConfiguration group) {
        LinkedList<ReplicaDataSourceDTO> result = new LinkedList<ReplicaDataSourceDTO>();
        for (String each : group.getReplicaDataSourceNames()) {
            result.add(new ReplicaDataSourceDTO(schemaName, group.getPrimaryDataSourceName(), each, !disabledSchemaDataSourceNames.contains(schemaName + "." + each)));
        }
        return result;
    }

    private Collection<String> getDisabledSchemaDataSourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        List schemaNames = this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.registryCenterService.getActivatedStateNode().getDataNodesPath());
        for (String schemaName : schemaNames) {
            List dataSourceNames = this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.registryCenterService.getActivatedStateNode().getSchemaPath(schemaName));
            for (String dataSourceName : dataSourceNames) {
                String value = this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivatedStateNode().getDataSourcePath(schemaName, dataSourceName));
                if (!RegistryCenterNodeStatus.DISABLED.toString().equalsIgnoreCase(value)) continue;
                result.add(Joiner.on((String)".").join((Object)schemaName, (Object)dataSourceName, new Object[0]));
            }
        }
        return result;
    }
}

