/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Optional;
import org.apache.shardingsphere.governance.core.config.ConfigCenterNode;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.apache.shardingsphere.ui.servcie.ConfigCenterService;
import org.apache.shardingsphere.ui.util.CenterRepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ConfigCenterServiceImpl
implements ConfigCenterService {
    @Autowired
    private CenterConfigService centerConfigService;

    @Override
    public ConfigurationRepository getActivatedConfigCenter() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated();
        if (optional.isPresent()) {
            return CenterRepositoryFactory.createConfigurationRepository(optional.get());
        }
        throw new ShardingSphereUIException(500, "No activated config center!");
    }

    @Override
    public ConfigCenterNode getActivateConfigurationNode() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated();
        if (optional.isPresent()) {
            return new ConfigCenterNode();
        }
        throw new ShardingSphereUIException(500, "No activated config center!");
    }
}

