/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Optional;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.domain.CenterConfigs;
import org.apache.shardingsphere.ui.common.dto.CenterConfigDTO;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.repository.CenterConfigsRepository;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class CenterConfigServiceImpl
implements CenterConfigService {
    @Autowired
    private CenterConfigsRepository centerConfigsRepository;

    @Override
    public CenterConfig load(String name) {
        return this.find(name, this.loadAll());
    }

    @Override
    public Optional<CenterConfig> loadActivated() {
        return Optional.ofNullable(this.findActivatedCenterConfiguration(this.loadAll()));
    }

    @Override
    public void add(CenterConfig config) {
        CenterConfigs configs = this.loadAll();
        CenterConfig existedConfig = this.find(config.getName(), configs);
        if (null != existedConfig) {
            throw new ShardingSphereUIException(500, String.format("Center %s already existed!", config.getName()));
        }
        configs.getCenterConfigs().add(config);
        this.centerConfigsRepository.save(configs);
    }

    @Override
    public void delete(String name) {
        CenterConfigs configs = this.loadAll();
        CenterConfig toBeRemovedConfig = this.find(name, configs);
        if (null != toBeRemovedConfig) {
            configs.getCenterConfigs().remove(toBeRemovedConfig);
            this.centerConfigsRepository.save(configs);
        }
    }

    @Override
    public void setActivated(String name) {
        CenterConfigs configs = this.loadAll();
        CenterConfig config = this.find(name, configs);
        if (null == config) {
            throw new ShardingSphereUIException(500, "Center not existed!");
        }
        CenterConfig activatedConfig = this.findActivatedCenterConfiguration(configs);
        if (!config.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            config.setActivated(true);
            this.centerConfigsRepository.save(configs);
        }
    }

    @Override
    public CenterConfigs loadAll() {
        return (CenterConfigs)this.centerConfigsRepository.load();
    }

    @Override
    public void update(CenterConfigDTO config) {
        CenterConfig existedConfig;
        CenterConfigs configs = this.loadAll();
        if (!config.getPrimaryName().equals(config.getName()) && null != (existedConfig = this.find(config.getName(), configs))) {
            throw new ShardingSphereUIException(500, String.format("Center %s already existed!", config.getName()));
        }
        CenterConfig toBeUpdatedConfig = this.find(config.getPrimaryName(), configs);
        if (null != toBeUpdatedConfig) {
            toBeUpdatedConfig.setName(config.getName());
            toBeUpdatedConfig.setInstanceType(config.getInstanceType());
            toBeUpdatedConfig.setServerLists(config.getServerLists());
            toBeUpdatedConfig.setGovernanceName(config.getGovernanceName());
            toBeUpdatedConfig.setDigest(config.getDigest());
            toBeUpdatedConfig.setAdditionalConfigCenterServerList(config.getAdditionalConfigCenterServerList());
            toBeUpdatedConfig.setAdditionalConfigCenterType(config.getAdditionalConfigCenterType());
            toBeUpdatedConfig.setAdditionalDigest(config.getAdditionalDigest());
            this.centerConfigsRepository.save(configs);
        }
    }

    private CenterConfig findActivatedCenterConfiguration(CenterConfigs centerConfigs) {
        return null == centerConfigs ? null : (CenterConfig)centerConfigs.getCenterConfigs().stream().filter(each -> each.isActivated()).findAny().orElse(null);
    }

    private CenterConfig find(String name, CenterConfigs configs) {
        return configs.getCenterConfigs().stream().filter(each -> name.equals(each.getName())).findAny().orElse(null);
    }
}

