/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaDataLoader;

public final class EncryptMetaDataLoader
implements LogicMetaDataLoader<EncryptRule> {
    public PhysicalSchemaMetaData load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, DataNodes dataNodes, EncryptRule encryptRule, ConfigurationProperties props, Collection<String> excludedTableNames) throws SQLException {
        DataSource dataSource = dataSourceMap.values().iterator().next();
        Collection<String> encryptTableNames = encryptRule.getEncryptTableNames();
        HashMap result = new HashMap(encryptTableNames.size(), 1.0f);
        for (String each : encryptTableNames) {
            if (excludedTableNames.contains(each)) continue;
            PhysicalTableMetaDataLoader.load((DataSource)dataSource, (String)each, (DatabaseType)databaseType).ifPresent(tableMetaData -> result.put(each, tableMetaData));
        }
        return new PhysicalSchemaMetaData(result);
    }

    public Optional<PhysicalTableMetaData> load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, DataNodes dataNodes, String tableName, EncryptRule encryptRule, ConfigurationProperties props) throws SQLException {
        return encryptRule.findEncryptTable(tableName).isPresent() ? PhysicalTableMetaDataLoader.load((DataSource)dataSourceMap.values().iterator().next(), (String)tableName, (DatabaseType)databaseType) : Optional.empty();
    }

    public int getOrder() {
        return 50;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

