/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.metadata.EncryptColumnMetaData;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;

public final class EncryptMetaDataDecorator
implements LogicMetaDataDecorator<EncryptRule> {
    public PhysicalTableMetaData decorate(String tableName, PhysicalTableMetaData tableMetaData, EncryptRule encryptRule) {
        return new PhysicalTableMetaData(this.getEncryptColumnMetaDataList(tableName, tableMetaData.getColumns().values(), encryptRule), tableMetaData.getIndexes().values());
    }

    private Collection<PhysicalColumnMetaData> getEncryptColumnMetaDataList(String tableName, Collection<PhysicalColumnMetaData> originalColumnMetaDataList, EncryptRule encryptRule) {
        LinkedList<PhysicalColumnMetaData> result = new LinkedList<PhysicalColumnMetaData>();
        Collection<String> derivedColumns = encryptRule.getAssistedQueryAndPlainColumns(tableName);
        for (PhysicalColumnMetaData each : originalColumnMetaDataList) {
            if (derivedColumns.contains(each.getName())) continue;
            result.add(this.getEncryptColumnMetaData(tableName, each, encryptRule));
        }
        return result;
    }

    private PhysicalColumnMetaData getEncryptColumnMetaData(String tableName, PhysicalColumnMetaData originalColumnMetaData, EncryptRule encryptRule) {
        if (!encryptRule.isCipherColumn(tableName, originalColumnMetaData.getName())) {
            return originalColumnMetaData;
        }
        String logicColumnName = encryptRule.getLogicColumnOfCipher(tableName, originalColumnMetaData.getName());
        String plainColumnName = encryptRule.findPlainColumn(tableName, logicColumnName).orElse(null);
        String assistedQueryColumnName = encryptRule.findAssistedQueryColumn(tableName, logicColumnName).orElse(null);
        return new EncryptColumnMetaData(logicColumnName, originalColumnMetaData.getDataType(), originalColumnMetaData.getDataTypeName(), originalColumnMetaData.isPrimaryKey(), originalColumnMetaData.getName(), plainColumnName, assistedQueryColumnName);
    }

    public int getOrder() {
        return 50;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

