/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class RC4EncryptAlgorithm
implements EncryptAlgorithm {
    private static final String RC4_KEY = "rc4-key-value";
    private static final int SBOX_LENGTH = 256;
    private static final int KEY_MIN_LENGTH = 5;
    private byte[] key = new byte[255];
    private int[] sBox = new int[256];
    private Properties props = new Properties();

    public void init() {
        this.reset();
        this.setKey(StringUtils.getBytesUtf8((String)this.props.getProperty(RC4_KEY)));
    }

    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        byte[] result = this.handle(StringUtils.getBytesUtf8((String)String.valueOf(plaintext)), this.key);
        return Base64.encodeBase64String((byte[])result);
    }

    public Object decrypt(String ciphertext) {
        if (null == ciphertext) {
            return null;
        }
        byte[] result = this.handle(Base64.decodeBase64((String)ciphertext), this.key);
        return new String(result, StandardCharsets.UTF_8);
    }

    private byte[] handle(byte[] data, byte[] key) {
        this.reset();
        this.setKey(key);
        byte[] result = this.crypt(data);
        this.reset();
        return result;
    }

    private void reset() {
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.sBox, 0);
    }

    private byte[] crypt(byte[] message) {
        this.sBox = this.initSBox(this.key);
        byte[] result = new byte[message.length];
        int i = 0;
        int j = 0;
        for (int n = 0; n < message.length; ++n) {
            i = (i + 1) % 256;
            j = (j + this.sBox[i]) % 256;
            this.swap(i, j, this.sBox);
            int rand = this.sBox[(this.sBox[i] + this.sBox[j]) % 256];
            result[n] = (byte)(rand ^ message[n]);
        }
        return result;
    }

    private int[] initSBox(byte[] key) {
        int i;
        int[] result = new int[256];
        int j = 0;
        for (i = 0; i < 256; ++i) {
            result[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            j = (j + result[i] + key[i % key.length] & 0xFF) % 256;
            this.swap(i, j, result);
        }
        return result;
    }

    private void swap(int i, int j, int[] sBox) {
        int temp = sBox[i];
        sBox[i] = sBox[j];
        sBox[j] = temp;
    }

    private void setKey(byte[] key) throws ShardingSphereException {
        if (key.length < 5 || key.length >= 256) {
            throw new ShardingSphereException("Key length has to be between 5 and 255", new Object[0]);
        }
        this.key = key;
    }

    public String getType() {
        return "RC4";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

