/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;

public final class AESEncryptAlgorithm
implements EncryptAlgorithm {
    private static final String AES_KEY = "aes-key-value";
    private Properties props = new Properties();
    private byte[] secretKey;

    public void init() {
        this.secretKey = this.createSecretKey();
    }

    private byte[] createSecretKey() {
        Preconditions.checkArgument((boolean)this.props.containsKey(AES_KEY), (Object)String.format("%s can not be null.", AES_KEY));
        return Arrays.copyOf(DigestUtils.sha1((String)this.props.getProperty(AES_KEY)), 16);
    }

    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(StringUtils.getBytesUtf8((String)String.valueOf(plaintext)));
        return Base64.encodeBase64String((byte[])result);
    }

    public Object decrypt(String ciphertext) {
        if (null == ciphertext) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(Base64.decodeBase64((String)ciphertext));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.secretKey, this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }
}

