/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.ordered;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPI;

public final class OrderedSPIRegistry {
    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getRegisteredServicesByClass(Collection<Class<?>> types, Class<T> orderedSPIClass) {
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type).forEach(type -> result.put(type, each));
        }
        return result;
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Collection<K> types, Class<V> orderedSPIClass) {
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(orderedSPIClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type.getClass()).forEach(type -> result.put(type, each));
        }
        return result;
    }

    private static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> orderedSPIClass) {
        TreeMap<Integer, OrderedSPI> result = new TreeMap<Integer, OrderedSPI>();
        for (OrderedSPI each : ShardingSphereServiceLoader.newServiceInstances(orderedSPIClass)) {
            result.put(each.getOrder(), each);
        }
        return result.values();
    }

    @Generated
    private OrderedSPIRegistry() {
    }
}

