/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.schema;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereSchema {
    private final String name;
    private final Collection<RuleConfiguration> configurations;
    private final Collection<ShardingSphereRule> rules;
    private final Map<String, DataSource> dataSources;
    private final ShardingSphereMetaData metaData;

    public boolean isComplete() {
        return !this.rules.isEmpty() && !this.dataSources.isEmpty();
    }

    public void closeDataSources(Collection<String> dataSources) throws SQLException {
        for (String each : dataSources) {
            this.close(this.dataSources.get(each));
        }
    }

    private void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)dataSource)).close();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
    }

    @Generated
    public ShardingSphereSchema(String name, Collection<RuleConfiguration> configurations, Collection<ShardingSphereRule> rules, Map<String, DataSource> dataSources, ShardingSphereMetaData metaData) {
        this.name = name;
        this.configurations = configurations;
        this.rules = rules;
        this.dataSources = dataSources;
        this.metaData = metaData;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Collection<RuleConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }

    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }
}

