/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;

public final class CreateViewStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<CreateViewStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, CreateViewStatement sqlStatement, TableMetaDataLoaderCallback callback) throws SQLException {
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        this.refreshUnconfiguredMetaData(metaData, routeDataSourceNames, viewName);
        metaData.getSchemaMetaData().getSchemaMetaData().put(viewName, new PhysicalTableMetaData());
    }

    private void refreshUnconfiguredMetaData(ShardingSphereMetaData metaData, Collection<String> routeDataSourceNames, String viewName) {
        for (String each : routeDataSourceNames) {
            this.refreshUnconfiguredMetaData(metaData, viewName, each);
        }
    }

    private void refreshUnconfiguredMetaData(ShardingSphereMetaData metaData, String viewName, String dataSourceName) {
        Collection<String> schemaMetaData = metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().get(dataSourceName);
        if (null == schemaMetaData) {
            metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().put(dataSourceName, Lists.newArrayList((Object[])new String[]{viewName}));
        } else {
            schemaMetaData.add(viewName);
        }
    }
}

