/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.schema;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.MetaDataConnectionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalSchemaMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"ShardingSphere-metadata");
    private static final String TABLE_TYPE = "TABLE";
    private static final String VIEW_TYPE = "VIEW";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static Collection<String> loadTableNames(DataSource dataSource, DatabaseType databaseType, Collection<String> excludedTableNames) throws SQLException {
        List<String> result;
        try (MetaDataConnectionAdapter connectionAdapter = new MetaDataConnectionAdapter(databaseType, dataSource.getConnection());){
            result = PhysicalSchemaMetaDataLoader.loadAllTableNames(connectionAdapter);
            result.removeAll(excludedTableNames);
        }
        log.info("Loading {} tables' meta data for unconfigured tables.", (Object)result.size());
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    private static List<String> loadAllTableNames(Connection connection) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{TABLE_TYPE, VIEW_TYPE});){
            while (resultSet.next()) {
                String table = resultSet.getString(TABLE_NAME);
                if (PhysicalSchemaMetaDataLoader.isSystemTable(table)) continue;
                result.add(table);
            }
        }
        return result;
    }

    private static boolean isSystemTable(String table) {
        return table.contains("$") || table.contains("/");
    }

    @Generated
    private PhysicalSchemaMetaDataLoader() {
    }
}

