/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;

public final class PhysicalSchemaMetaData {
    private final Map<String, PhysicalTableMetaData> tables;

    public PhysicalSchemaMetaData() {
        this.tables = new ConcurrentHashMap<String, PhysicalTableMetaData>();
    }

    public PhysicalSchemaMetaData(Map<String, PhysicalTableMetaData> tables) {
        this.tables = new ConcurrentHashMap<String, PhysicalTableMetaData>(tables.size(), 1.0f);
        tables.forEach((key, value) -> this.tables.put(key.toLowerCase(), (PhysicalTableMetaData)value));
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public PhysicalTableMetaData get(String tableName) {
        return this.tables.get(tableName.toLowerCase());
    }

    public void merge(PhysicalSchemaMetaData schemaMetaData) {
        this.tables.putAll(schemaMetaData.tables);
    }

    public void put(String tableName, PhysicalTableMetaData tableMetaData) {
        this.tables.put(tableName.toLowerCase(), tableMetaData);
    }

    public void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName.toLowerCase());
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.containsTable(tableName) && this.get(tableName).getColumns().containsKey(columnName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.containsTable(tableName) ? new ArrayList<String>(this.get(tableName).getColumns().keySet()) : Collections.emptyList();
    }
}

