/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.jdbc.handler.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.handler.DatabaseMetaDataDialectHandler;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;

public final class OracleDatabaseMetaDataDialectHandler
implements DatabaseMetaDataDialectHandler {
    private Properties props;

    @Override
    public String getSchema(Connection connection) {
        try {
            return Optional.ofNullable(connection.getMetaData().getUserName()).map(String::toUpperCase).orElse(null);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    @Override
    public String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern.toUpperCase();
    }

    @Override
    public QuoteCharacter getQuoteCharacter() {
        return QuoteCharacter.QUOTE;
    }

    @Override
    public String getType() {
        return "Oracle";
    }

    @Override
    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Override
    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

