/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.logic;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;

public final class LogicSchemaMetaData {
    private final PhysicalSchemaMetaData configuredSchemaMetaData;
    private final Map<String, Collection<String>> unconfiguredSchemaMetaDataMap;
    private final PhysicalSchemaMetaData allSchemaMetaData;

    public LogicSchemaMetaData(PhysicalSchemaMetaData configuredSchemaMetaData, Map<String, Collection<String>> unconfiguredSchemaMetaDataMap) {
        this.configuredSchemaMetaData = configuredSchemaMetaData;
        this.unconfiguredSchemaMetaDataMap = unconfiguredSchemaMetaDataMap;
        this.allSchemaMetaData = this.createSchemaMetaData();
    }

    private PhysicalSchemaMetaData createSchemaMetaData() {
        PhysicalSchemaMetaData result = new PhysicalSchemaMetaData();
        this.unconfiguredSchemaMetaDataMap.values().stream().flatMap(Collection::stream).forEach(tableName -> result.put((String)tableName, new PhysicalTableMetaData()));
        result.merge(this.configuredSchemaMetaData);
        return result;
    }

    public PhysicalSchemaMetaData getSchemaMetaData() {
        return this.allSchemaMetaData;
    }

    public Collection<String> getAllTableNames() {
        LinkedList<String> result = new LinkedList<String>(this.configuredSchemaMetaData.getAllTableNames());
        this.unconfiguredSchemaMetaDataMap.values().forEach(result::addAll);
        return result;
    }

    @Generated
    public PhysicalSchemaMetaData getConfiguredSchemaMetaData() {
        return this.configuredSchemaMetaData;
    }

    @Generated
    public Map<String, Collection<String>> getUnconfiguredSchemaMetaDataMap() {
        return this.unconfiguredSchemaMetaDataMap;
    }
}

