/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.governance.repository.etcd;

import com.google.common.base.Splitter;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Observers;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.governance.repository.api.ConfigurationRepository;
import org.apache.shardingsphere.governance.repository.api.RegistryRepository;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceCenterConfiguration;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEvent;
import org.apache.shardingsphere.governance.repository.api.listener.DataChangedEventListener;
import org.apache.shardingsphere.governance.repository.etcd.EtcdProperties;
import org.apache.shardingsphere.governance.repository.etcd.EtcdPropertyKey;

public final class EtcdRepository
implements ConfigurationRepository,
RegistryRepository {
    private Client client;
    private Properties props = new Properties();
    private EtcdProperties etcdProperties;

    public void init(String name, GovernanceCenterConfiguration config) {
        this.etcdProperties = new EtcdProperties(this.props);
        this.client = Client.builder().endpoints((Collection)Util.toURIs((Collection)Splitter.on((String)",").trimResults().splitToList((CharSequence)config.getServerLists()))).namespace(ByteSequence.from((String)name, (Charset)StandardCharsets.UTF_8)).build();
    }

    public String get(String key) {
        List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
        return keyValues.isEmpty() ? null : ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
    }

    public List<String> getChildrenKeys(String key) {
        String prefix = key + "/";
        ByteSequence prefixByteSequence = ByteSequence.from((String)prefix, (Charset)StandardCharsets.UTF_8);
        GetOption getOption = GetOption.newBuilder().withPrefix(prefixByteSequence).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(prefixByteSequence, getOption).get()).getKvs();
        return keyValues.stream().map(e -> this.getSubNodeKeyName(prefix, e.getKey().toString(StandardCharsets.UTF_8))).distinct().collect(Collectors.toList());
    }

    private String getSubNodeKeyName(String prefix, String fullPath) {
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains("/") ? pathWithoutPrefix.substring(0, pathWithoutPrefix.indexOf("/")) : pathWithoutPrefix;
    }

    public void persist(String key, String value) {
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8)).get();
    }

    public void persistEphemeral(String key, String value) {
        long leaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(((Long)this.etcdProperties.getValue(EtcdPropertyKey.TIME_TO_LIVE_SECONDS)).longValue()).get()).getID();
        this.client.getLeaseClient().keepAlive(leaseId, Observers.observer(response -> {}));
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8), PutOption.newBuilder().withLeaseId(leaseId).build()).get();
    }

    public void delete(String key) {
        this.client.getKVClient().delete(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8));
    }

    public void watch(String key, DataChangedEventListener dataChangedEventListener) {
        Watch.Listener listener = Watch.listener(response -> {
            for (WatchEvent each : response.getEvents()) {
                DataChangedEvent.ChangedType changedType = this.getEventChangedType(each);
                if (DataChangedEvent.ChangedType.IGNORED == changedType) continue;
                dataChangedEventListener.onChange(new DataChangedEvent(each.getKeyValue().getKey().toString(StandardCharsets.UTF_8), each.getKeyValue().getValue().toString(StandardCharsets.UTF_8), changedType));
            }
        });
        this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), listener);
    }

    private DataChangedEvent.ChangedType getEventChangedType(WatchEvent event) {
        switch (event.getEventType()) {
            case PUT: {
                return DataChangedEvent.ChangedType.UPDATED;
            }
            case DELETE: {
                return DataChangedEvent.ChangedType.DELETED;
            }
        }
        return DataChangedEvent.ChangedType.IGNORED;
    }

    public void close() {
        this.client.close();
    }

    public String getType() {
        return "etcd";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

