/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.yaml.swapper;

import java.util.Map;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.ShardingAutoTableRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.rule.ShardingTableRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.KeyGenerateStrategyConfigurationYamlSwapper;
import org.apache.shardingsphere.sharding.yaml.swapper.strategy.ShardingStrategyConfigurationYamlSwapper;

public final class ShardingRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlShardingRuleConfiguration, ShardingRuleConfiguration> {
    private final ShardingTableRuleConfigurationYamlSwapper tableYamlSwapper = new ShardingTableRuleConfigurationYamlSwapper();
    private final ShardingAutoTableRuleConfigurationYamlSwapper autoTableYamlSwapper = new ShardingAutoTableRuleConfigurationYamlSwapper();
    private final ShardingStrategyConfigurationYamlSwapper shardingStrategyYamlSwapper = new ShardingStrategyConfigurationYamlSwapper();
    private final KeyGenerateStrategyConfigurationYamlSwapper keyGenerateStrategyYamlSwapper = new KeyGenerateStrategyConfigurationYamlSwapper();
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlShardingRuleConfiguration swapToYamlConfiguration(ShardingRuleConfiguration data) {
        YamlShardingRuleConfiguration result = new YamlShardingRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getLogicTable(), this.tableYamlSwapper.swapToYamlConfiguration((ShardingTableRuleConfiguration)each)));
        data.getAutoTables().forEach(each -> result.getAutoTables().put(each.getLogicTable(), this.autoTableYamlSwapper.swapToYamlConfiguration((ShardingAutoTableRuleConfiguration)each)));
        result.getBindingTables().addAll(data.getBindingTableGroups());
        result.getBroadcastTables().addAll(data.getBroadcastTables());
        this.setYamlDefaultStrategies(data, result);
        this.setYamlAlgorithms(data, result);
        return result;
    }

    private void setYamlDefaultStrategies(ShardingRuleConfiguration data, YamlShardingRuleConfiguration yamlConfig) {
        if (null != data.getDefaultDatabaseShardingStrategy()) {
            yamlConfig.setDefaultDatabaseStrategy(this.shardingStrategyYamlSwapper.swapToYamlConfiguration(data.getDefaultDatabaseShardingStrategy()));
        }
        if (null != data.getDefaultTableShardingStrategy()) {
            yamlConfig.setDefaultTableStrategy(this.shardingStrategyYamlSwapper.swapToYamlConfiguration(data.getDefaultTableShardingStrategy()));
        }
        if (null != data.getDefaultKeyGenerateStrategy()) {
            yamlConfig.setDefaultKeyGenerateStrategy(this.keyGenerateStrategyYamlSwapper.swapToYamlConfiguration(data.getDefaultKeyGenerateStrategy()));
        }
    }

    private void setYamlAlgorithms(ShardingRuleConfiguration data, YamlShardingRuleConfiguration yamlConfig) {
        if (null != data.getShardingAlgorithms()) {
            data.getShardingAlgorithms().forEach((key, value) -> yamlConfig.getShardingAlgorithms().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
        if (null != data.getKeyGenerators()) {
            data.getKeyGenerators().forEach((key, value) -> yamlConfig.getKeyGenerators().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        }
    }

    public ShardingRuleConfiguration swapToObject(YamlShardingRuleConfiguration yamlConfig) {
        Object tableRuleConfig;
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            tableRuleConfig = entry.getValue();
            ((YamlTableRuleConfiguration)tableRuleConfig).setLogicTable(entry.getKey());
            result.getTables().add(this.tableYamlSwapper.swapToObject((YamlTableRuleConfiguration)tableRuleConfig));
        }
        for (Map.Entry<String, Object> entry : yamlConfig.getAutoTables().entrySet()) {
            tableRuleConfig = (YamlShardingAutoTableRuleConfiguration)entry.getValue();
            ((YamlShardingAutoTableRuleConfiguration)tableRuleConfig).setLogicTable(entry.getKey());
            result.getAutoTables().add(this.autoTableYamlSwapper.swapToObject((YamlShardingAutoTableRuleConfiguration)tableRuleConfig));
        }
        result.getBindingTableGroups().addAll(yamlConfig.getBindingTables());
        result.getBroadcastTables().addAll(yamlConfig.getBroadcastTables());
        this.setDefaultStrategies(yamlConfig, result);
        this.setAlgorithms(yamlConfig, result);
        return result;
    }

    private void setDefaultStrategies(YamlShardingRuleConfiguration yamlConfig, ShardingRuleConfiguration ruleConfig) {
        if (null != yamlConfig.getDefaultDatabaseStrategy()) {
            ruleConfig.setDefaultDatabaseShardingStrategy(this.shardingStrategyYamlSwapper.swapToObject(yamlConfig.getDefaultDatabaseStrategy()));
        }
        if (null != yamlConfig.getDefaultTableStrategy()) {
            ruleConfig.setDefaultTableShardingStrategy(this.shardingStrategyYamlSwapper.swapToObject(yamlConfig.getDefaultTableStrategy()));
        }
        if (null != yamlConfig.getDefaultKeyGenerateStrategy()) {
            ruleConfig.setDefaultKeyGenerateStrategy(this.keyGenerateStrategyYamlSwapper.swapToObject(yamlConfig.getDefaultKeyGenerateStrategy()));
        }
    }

    private void setAlgorithms(YamlShardingRuleConfiguration yamlConfig, ShardingRuleConfiguration ruleConfig) {
        if (null != yamlConfig.getShardingAlgorithms()) {
            yamlConfig.getShardingAlgorithms().forEach((key, value) -> ruleConfig.getShardingAlgorithms().put(key, this.algorithmSwapper.swapToObject(value)));
        }
        if (null != yamlConfig.getKeyGenerators()) {
            yamlConfig.getKeyGenerators().forEach((key, value) -> ruleConfig.getKeyGenerators().put(key, this.algorithmSwapper.swapToObject(value)));
        }
    }

    public Class<ShardingRuleConfiguration> getTypeClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SHARDING";
    }

    public int getOrder() {
        return 0;
    }
}

