/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaDataLoader;
import org.apache.shardingsphere.sharding.metadata.ShardingMetaDataDecorator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingMetaDataLoader
implements LogicMetaDataLoader<ShardingRule> {
    private static final int CPU_CORES = Runtime.getRuntime().availableProcessors();
    private static final int FUTURE_GET_TIME_OUT_SECOND = 5;

    public PhysicalSchemaMetaData load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, DataNodes dataNodes, ShardingRule rule, ConfigurationProperties props, Collection<String> excludedTableNames) throws SQLException {
        PhysicalSchemaMetaData result = new PhysicalSchemaMetaData(new HashMap(rule.getTableRules().size(), 1.0f));
        for (TableRule each : rule.getTableRules()) {
            if (excludedTableNames.contains(each.getLogicTable())) continue;
            this.load(databaseType, dataSourceMap, dataNodes, each.getLogicTable(), rule, props).ifPresent(tableMetaData -> result.put(each.getLogicTable(), tableMetaData));
        }
        return result;
    }

    public Optional<PhysicalTableMetaData> load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, DataNodes dataNodes, String tableName, ShardingRule rule, ConfigurationProperties props) throws SQLException {
        if (!rule.findTableRule(tableName).isPresent()) {
            return Optional.empty();
        }
        boolean isCheckingMetaData = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.CHECK_TABLE_METADATA_ENABLED);
        int maxConnectionsSizePerQuery = (Integer)props.getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        TableRule tableRule = rule.getTableRule(tableName);
        if (!isCheckingMetaData) {
            DataNode dataNode = (DataNode)dataNodes.getDataNodes(tableName).iterator().next();
            return PhysicalTableMetaDataLoader.load((DataSource)dataSourceMap.get(dataNode.getDataSourceName()), (String)dataNode.getTableName(), (DatabaseType)databaseType);
        }
        Map<String, PhysicalTableMetaData> actualTableMetaDataMap = this.parallelLoadTables(databaseType, dataSourceMap, dataNodes, tableName, maxConnectionsSizePerQuery);
        if (actualTableMetaDataMap.isEmpty()) {
            return Optional.empty();
        }
        this.checkUniformed(tableRule.getLogicTable(), actualTableMetaDataMap, rule);
        return Optional.of(actualTableMetaDataMap.values().iterator().next());
    }

    private Map<String, PhysicalTableMetaData> parallelLoadTables(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, DataNodes dataNodes, String tableName, int maxConnectionsSizePerQuery) {
        Map dataNodeGroups = dataNodes.getDataNodeGroups(tableName);
        HashMap<String, PhysicalTableMetaData> result = new HashMap<String, PhysicalTableMetaData>(dataNodeGroups.size(), 1.0f);
        HashMap<String, Future> tableFutureMap = new HashMap<String, Future>(dataNodeGroups.size(), 1.0f);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(CPU_CORES * 2, dataNodeGroups.size() * maxConnectionsSizePerQuery));
        for (Map.Entry entry : dataNodeGroups.entrySet()) {
            for (DataNode each : (List)entry.getValue()) {
                Future<Optional> futures = executorService.submit(() -> this.loadTableByDataNode(each, databaseType, dataSourceMap));
                tableFutureMap.put(each.getTableName(), futures);
            }
        }
        tableFutureMap.forEach((key, value) -> {
            try {
                this.getTableMetaData((Future<Optional<PhysicalTableMetaData>>)value).ifPresent(tableMetaData -> result.put((String)key, (PhysicalTableMetaData)tableMetaData));
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new IllegalStateException(String.format("Error while fetching tableMetaData with key= %s and Value=%s", key, value), ex);
            }
        });
        executorService.shutdownNow();
        return result;
    }

    private Optional<PhysicalTableMetaData> getTableMetaData(Future<Optional<PhysicalTableMetaData>> value) throws InterruptedException, ExecutionException, TimeoutException {
        return value.get(5L, TimeUnit.SECONDS);
    }

    private Optional<PhysicalTableMetaData> loadTableByDataNode(DataNode dataNode, DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        try {
            return PhysicalTableMetaDataLoader.load((DataSource)dataSourceMap.get(dataNode.getDataSourceName()), (String)dataNode.getTableName(), (DatabaseType)databaseType);
        }
        catch (SQLException ex) {
            throw new IllegalStateException(String.format("SQLException for DataNode=%s and databaseType=%s", dataNode, databaseType.getName()), ex);
        }
    }

    private void checkUniformed(String logicTableName, Map<String, PhysicalTableMetaData> actualTableMetaDataMap, ShardingRule shardingRule) {
        ShardingMetaDataDecorator decorator = new ShardingMetaDataDecorator();
        PhysicalTableMetaData sample = decorator.decorate(logicTableName, actualTableMetaDataMap.values().iterator().next(), shardingRule);
        Collection violations = actualTableMetaDataMap.entrySet().stream().filter(entry -> !sample.equals((Object)decorator.decorate(logicTableName, (PhysicalTableMetaData)entry.getValue(), shardingRule))).map(entry -> new TableMetaDataViolation((String)entry.getKey(), (PhysicalTableMetaData)entry.getValue())).collect(Collectors.toList());
        this.throwExceptionIfNecessary(violations, logicTableName);
    }

    private void throwExceptionIfNecessary(Collection<TableMetaDataViolation> violations, String logicTableName) {
        if (!violations.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Cannot get uniformed table structure for logic table `%s`, it has different meta data of actual tables are as follows:").append(System.lineSeparator());
            for (TableMetaDataViolation each : violations) {
                errorMessage.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
            }
            throw new ShardingSphereException(errorMessage.toString(), new Object[]{logicTableName});
        }
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }

    private static final class TableMetaDataViolation {
        private final String actualTableName;
        private final PhysicalTableMetaData tableMetaData;

        @Generated
        public TableMetaDataViolation(String actualTableName, PhysicalTableMetaData tableMetaData) {
            this.actualTableName = actualTableName;
            this.tableMetaData = tableMetaData;
        }

        @Generated
        public String getActualTableName() {
            return this.actualTableName;
        }

        @Generated
        public PhysicalTableMetaData getTableMetaData() {
            return this.tableMetaData;
        }
    }
}

