/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.index.PhysicalIndexMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingMetaDataDecorator
implements LogicMetaDataDecorator<ShardingRule> {
    public PhysicalTableMetaData decorate(String tableName, PhysicalTableMetaData tableMetaData, ShardingRule shardingRule) {
        return shardingRule.findTableRule(tableName).map(tableRule -> new PhysicalTableMetaData(this.getColumnMetaDataList(tableMetaData, (TableRule)tableRule), this.getIndexMetaDataList(tableMetaData, (TableRule)tableRule))).orElse(tableMetaData);
    }

    private Collection<PhysicalColumnMetaData> getColumnMetaDataList(PhysicalTableMetaData tableMetaData, TableRule tableRule) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        if (!generateKeyColumn.isPresent()) {
            return tableMetaData.getColumns().values();
        }
        LinkedList<PhysicalColumnMetaData> result = new LinkedList<PhysicalColumnMetaData>();
        for (Map.Entry entry : tableMetaData.getColumns().entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase(generateKeyColumn.get())) {
                result.add(new PhysicalColumnMetaData(((PhysicalColumnMetaData)entry.getValue()).getName(), ((PhysicalColumnMetaData)entry.getValue()).getDataType(), ((PhysicalColumnMetaData)entry.getValue()).getDataTypeName(), ((PhysicalColumnMetaData)entry.getValue()).isPrimaryKey(), true, ((PhysicalColumnMetaData)entry.getValue()).isCaseSensitive()));
                continue;
            }
            result.add((PhysicalColumnMetaData)entry.getValue());
        }
        return result;
    }

    private Collection<PhysicalIndexMetaData> getIndexMetaDataList(PhysicalTableMetaData tableMetaData, TableRule tableRule) {
        HashSet<PhysicalIndexMetaData> result = new HashSet<PhysicalIndexMetaData>();
        for (Map.Entry entry : tableMetaData.getIndexes().entrySet()) {
            for (DataNode each : tableRule.getActualDataNodes()) {
                this.getLogicIndex((String)entry.getKey(), each.getTableName()).ifPresent(logicIndex -> result.add(new PhysicalIndexMetaData(logicIndex)));
            }
        }
        return result;
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? Optional.of(actualIndexName.replace(indexNameSuffix, "")) : Optional.empty();
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

