/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.range;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public abstract class AbstractRangeShardingAlgorithm
implements StandardShardingAlgorithm<Long>,
ShardingAutoTableAlgorithm {
    private volatile Map<Integer, Range<Long>> partitionRange;
    private Properties props = new Properties();

    public final void init() {
        this.partitionRange = this.calculatePartitionRange(this.props);
    }

    protected abstract Map<Integer, Range<Long>> calculatePartitionRange(Properties var1);

    public final String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Long> shardingValue) {
        return availableTargetNames.stream().filter(each -> each.endsWith(String.valueOf(this.getPartition((Long)shardingValue.getValue())))).findFirst().orElse(null);
    }

    public final Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Long> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        int firstPartition = this.getFirstPartition((Range<Long>)shardingValue.getValueRange());
        int lastPartition = this.getLastPartition((Range<Long>)shardingValue.getValueRange());
        for (int partition = firstPartition; partition <= lastPartition; ++partition) {
            for (String each : availableTargetNames) {
                if (!each.endsWith(String.valueOf(partition))) continue;
                result.add(each);
            }
        }
        return result;
    }

    private int getFirstPartition(Range<Long> valueRange) {
        return valueRange.hasLowerBound() ? this.getPartition((Long)valueRange.lowerEndpoint()) : 0;
    }

    private int getLastPartition(Range<Long> valueRange) {
        return valueRange.hasUpperBound() ? this.getPartition((Long)valueRange.upperEndpoint()) : this.partitionRange.size() - 1;
    }

    private Integer getPartition(Long value) {
        for (Map.Entry<Integer, Range<Long>> entry : this.partitionRange.entrySet()) {
            if (!entry.getValue().contains((Comparable)value)) continue;
            return entry.getKey();
        }
        throw new UnsupportedOperationException("");
    }

    public final int getAutoTablesAmount() {
        return this.partitionRange.size();
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

