/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.mod;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class ModShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String SHARDING_COUNT_KEY = "sharding-count";
    private Properties props = new Properties();
    private int shardingCount;

    public void init() {
        this.shardingCount = this.getShardingCount();
    }

    private int getShardingCount() {
        Preconditions.checkArgument((boolean)this.props.containsKey(SHARDING_COUNT_KEY), (Object)"Sharding count cannot be null.");
        return Integer.parseInt(this.props.get(SHARDING_COUNT_KEY).toString());
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        for (String each : availableTargetNames) {
            if (!each.endsWith(String.valueOf(this.getLongValue(shardingValue.getValue()) % (long)this.shardingCount))) continue;
            return each;
        }
        return null;
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.isContainAllTargets(shardingValue) ? availableTargetNames : this.getAvailableTargetNames(availableTargetNames, shardingValue);
    }

    private boolean isContainAllTargets(RangeShardingValue<Comparable<?>> shardingValue) {
        return !shardingValue.getValueRange().hasUpperBound() || shardingValue.getValueRange().hasLowerBound() && this.getLongValue(shardingValue.getValueRange().upperEndpoint()) - this.getLongValue(shardingValue.getValueRange().lowerEndpoint()) >= (long)(this.shardingCount - 1);
    }

    private Collection<String> getAvailableTargetNames(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        for (long i = this.getLongValue(shardingValue.getValueRange().lowerEndpoint()); i <= this.getLongValue(shardingValue.getValueRange().upperEndpoint()); ++i) {
            for (String each : availableTargetNames) {
                if (!each.endsWith(String.valueOf(i % (long)this.shardingCount))) continue;
                result.add(each);
            }
        }
        return result;
    }

    private long getLongValue(Comparable<?> value) {
        return Long.parseLong(value.toString());
    }

    public int getAutoTablesAmount() {
        return this.shardingCount;
    }

    public String getType() {
        return "MOD";
    }

    public Collection<String> getAllPropertyKeys() {
        return Collections.singletonList(SHARDING_COUNT_KEY);
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setShardingCount(int shardingCount) {
        this.shardingCount = shardingCount;
    }
}

