/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.sharding.algorithm.sharding.ShardingAlgorithmException;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class IntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>> {
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    private static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    private Properties props = new Properties();
    private DateTimeFormatter dateTimeFormatter;
    private int dateTimePatternLength;
    private LocalDateTime dateTimeLower;
    private LocalDateTime dateTimeUpper;
    private DateTimeFormatter tableSuffixPattern;
    private int stepAmount;
    private ChronoUnit stepUnit;

    public void init() {
        String dateTimePattern = this.getDateTimePattern();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
        this.dateTimePatternLength = dateTimePattern.length();
        this.dateTimeLower = this.getDateTimeLower(dateTimePattern);
        this.dateTimeUpper = this.getDateTimeUpper(dateTimePattern);
        this.tableSuffixPattern = this.getTableSuffixPattern();
        this.stepAmount = Integer.parseInt(this.props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        this.stepUnit = this.props.containsKey(INTERVAL_UNIT_KEY) ? this.getStepUnit(this.props.getProperty(INTERVAL_UNIT_KEY)) : ChronoUnit.DAYS;
    }

    private String getDateTimePattern() {
        Preconditions.checkArgument((boolean)this.props.containsKey(DATE_TIME_PATTERN_KEY), (String)"% can not be null.", (Object)DATE_TIME_PATTERN_KEY);
        return this.props.getProperty(DATE_TIME_PATTERN_KEY);
    }

    private LocalDateTime getDateTimeLower(String dateTimePattern) {
        Preconditions.checkArgument((boolean)this.props.containsKey(DATE_TIME_LOWER_KEY), (String)"% can not be null.", (Object)DATE_TIME_LOWER_KEY);
        return this.getDateTime(DATE_TIME_LOWER_KEY, this.props.getProperty(DATE_TIME_LOWER_KEY), dateTimePattern);
    }

    private LocalDateTime getDateTimeUpper(String dateTimePattern) {
        return this.props.containsKey(DATE_TIME_UPPER_KEY) ? this.getDateTime(DATE_TIME_UPPER_KEY, this.props.getProperty(DATE_TIME_UPPER_KEY), dateTimePattern) : LocalDateTime.now();
    }

    private LocalDateTime getDateTime(String dateTimeKey, String dateTimeValue, String dateTimePattern) {
        try {
            return LocalDateTime.parse(dateTimeValue, this.dateTimeFormatter);
        }
        catch (DateTimeParseException ex) {
            throw new ShardingSphereConfigurationException("Invalid %s, datetime pattern should be `%s`, value is `%s`", new Object[]{dateTimeKey, dateTimePattern, dateTimeValue});
        }
    }

    private DateTimeFormatter getTableSuffixPattern() {
        Preconditions.checkArgument((boolean)this.props.containsKey(SHARDING_SUFFIX_FORMAT_KEY), (String)"% can not be null.", (Object)SHARDING_SUFFIX_FORMAT_KEY);
        return DateTimeFormatter.ofPattern(this.props.getProperty(SHARDING_SUFFIX_FORMAT_KEY));
    }

    private ChronoUnit getStepUnit(String stepUnit) {
        for (ChronoUnit each : ChronoUnit.values()) {
            if (!each.toString().equalsIgnoreCase(stepUnit)) continue;
            return each;
        }
        throw new UnsupportedOperationException(String.format("Cannot find step unit for specified %s property: `%s`", INTERVAL_UNIT_KEY, stepUnit));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        return availableTargetNames.stream().filter(each -> each.endsWith(this.parseDateTime(shardingValue.getValue().toString()).format(this.tableSuffixPattern))).findFirst().orElseThrow(() -> new ShardingAlgorithmException(String.format("failed to shard value %s, and availableTables %s", shardingValue, availableTargetNames), new Object[0]));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        boolean hasStartTime = shardingValue.getValueRange().hasLowerBound();
        boolean hasEndTime = shardingValue.getValueRange().hasUpperBound();
        if (!hasStartTime && !hasEndTime) {
            return availableTargetNames;
        }
        LocalDateTime startTime = hasStartTime ? this.parseDateTime(shardingValue.getValueRange().lowerEndpoint().toString()) : this.dateTimeLower;
        LocalDateTime endTime = hasEndTime ? this.parseDateTime(shardingValue.getValueRange().upperEndpoint().toString()) : this.dateTimeUpper;
        LocalDateTime calculateTime = startTime;
        HashSet<String> result = new HashSet<String>();
        while (!calculateTime.isAfter(endTime)) {
            result.addAll(this.getMatchedTables(calculateTime, availableTargetNames));
            calculateTime = calculateTime.plus(this.stepAmount, this.stepUnit);
        }
        result.addAll(this.getMatchedTables(endTime, availableTargetNames));
        return result;
    }

    private LocalDateTime parseDateTime(String value) {
        return LocalDateTime.parse(value.substring(0, this.dateTimePatternLength), this.dateTimeFormatter);
    }

    private Collection<String> getMatchedTables(LocalDateTime dateTime, Collection<String> availableTargetNames) {
        String tableSuffix = dateTime.format(this.tableSuffixPattern);
        return availableTargetNames.parallelStream().filter(each -> each.endsWith(tableSuffix)).collect(Collectors.toSet());
    }

    public String getType() {
        return "INTERVAL";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

