/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.yaml.swapper;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.spi.typed.TypedSPI;
import org.apache.shardingsphere.infra.yaml.config.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.replicaquery.algorithm.config.AlgorithmProvidedReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.config.YamlReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.config.rule.YamlReplicaQueryDataSourceRuleConfiguration;

public final class ReplicaQueryRuleAlgorithmProviderConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlReplicaQueryRuleConfiguration, AlgorithmProvidedReplicaQueryRuleConfiguration> {
    public YamlReplicaQueryRuleConfiguration swapToYamlConfiguration(AlgorithmProvidedReplicaQueryRuleConfiguration data) {
        YamlReplicaQueryRuleConfiguration result = new YamlReplicaQueryRuleConfiguration();
        result.setDataSources(data.getDataSources().stream().collect(Collectors.toMap(ReplicaQueryDataSourceRuleConfiguration::getName, this::swapToYamlConfiguration, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        if (null != data.getLoadBalanceAlgorithms()) {
            data.getLoadBalanceAlgorithms().forEach((key, value) -> result.getLoadBalancers().put((String)key, YamlShardingSphereAlgorithmConfiguration.buildByTypedSPI((TypedSPI)value)));
        }
        return result;
    }

    private YamlReplicaQueryDataSourceRuleConfiguration swapToYamlConfiguration(ReplicaQueryDataSourceRuleConfiguration dataSourceRuleConfig) {
        YamlReplicaQueryDataSourceRuleConfiguration result = new YamlReplicaQueryDataSourceRuleConfiguration();
        result.setName(dataSourceRuleConfig.getName());
        result.setPrimaryDataSourceName(dataSourceRuleConfig.getPrimaryDataSourceName());
        result.setReplicaDataSourceNames(dataSourceRuleConfig.getReplicaDataSourceNames());
        result.setLoadBalancerName(dataSourceRuleConfig.getLoadBalancerName());
        return result;
    }

    public AlgorithmProvidedReplicaQueryRuleConfiguration swapToObject(YamlReplicaQueryRuleConfiguration yamlConfig) {
        LinkedList<ReplicaQueryDataSourceRuleConfiguration> dataSources = new LinkedList<ReplicaQueryDataSourceRuleConfiguration>();
        for (Map.Entry<String, YamlReplicaQueryDataSourceRuleConfiguration> entry : yamlConfig.getDataSources().entrySet()) {
            dataSources.add(this.swapToObject(entry.getKey(), entry.getValue()));
        }
        AlgorithmProvidedReplicaQueryRuleConfiguration ruleConfig = new AlgorithmProvidedReplicaQueryRuleConfiguration();
        ruleConfig.setDataSources(dataSources);
        return ruleConfig;
    }

    private ReplicaQueryDataSourceRuleConfiguration swapToObject(String name, YamlReplicaQueryDataSourceRuleConfiguration yamlDataSourceRuleConfig) {
        return new ReplicaQueryDataSourceRuleConfiguration(name, yamlDataSourceRuleConfig.getPrimaryDataSourceName(), yamlDataSourceRuleConfig.getReplicaDataSourceNames(), yamlDataSourceRuleConfig.getLoadBalancerName());
    }

    public Class<AlgorithmProvidedReplicaQueryRuleConfiguration> getTypeClass() {
        return AlgorithmProvidedReplicaQueryRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "REPLICA_QUERY";
    }

    public int getOrder() {
        return 11;
    }
}

