/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementContext
extends CommonSQLStatementContext<AlterTableStatement>
implements TableAvailable {
    private final TablesContext tablesContext;

    public AlterTableStatementContext(AlterTableStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(((AlterTableStatement)this.getSqlStatement()).getTable());
        for (AddColumnDefinitionSegment each : ((AlterTableStatement)this.getSqlStatement()).getAddColumnDefinitions()) {
            for (ColumnDefinitionSegment columnDefinition : each.getColumnDefinitions()) {
                result.addAll(columnDefinition.getReferencedTables());
            }
        }
        for (AddColumnDefinitionSegment each : ((AlterTableStatement)this.getSqlStatement()).getModifyColumnDefinitions()) {
            result.addAll(each.getColumnDefinition().getReferencedTables());
        }
        for (AddColumnDefinitionSegment each : ((AlterTableStatement)this.getSqlStatement()).getAddConstraintDefinitions()) {
            if (!each.getReferencedTable().isPresent()) continue;
            result.add((SimpleTableSegment)each.getReferencedTable().get());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

