/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.value.identifier;

import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.ValueASTNode;

public final class IdentifierValue
implements ValueASTNode<String> {
    private final String value;
    private final QuoteCharacter quoteCharacter;

    public IdentifierValue(String text) {
        this.value = SQLUtil.getExactlyValue(text);
        this.quoteCharacter = QuoteCharacter.getQuoteCharacter(text);
    }

    public String getValueWithQuoteCharacters() {
        return null == this.value ? "" : this.quoteCharacter.wrap(this.value);
    }

    @Override
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Generated
    public String toString() {
        return "IdentifierValue(value=" + this.getValue() + ", quoteCharacter=" + (Object)((Object)this.getQuoteCharacter()) + ")";
    }
}

