/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.facade;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.RegistryCenterRepository;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.core.common.CenterType;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenter;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenterRepositoryServiceLoader;
import org.apache.shardingsphere.orchestration.core.facade.listener.ShardingOrchestrationListenerManager;
import org.apache.shardingsphere.orchestration.core.facade.properties.OrchestrationProperties;
import org.apache.shardingsphere.orchestration.core.facade.properties.OrchestrationPropertyKey;
import org.apache.shardingsphere.orchestration.core.registrycenter.RegistryCenter;
import org.apache.shardingsphere.orchestration.core.registrycenter.RegistryCenterRepositoryServiceLoader;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingOrchestrationFacade
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingOrchestrationFacade.class);
    private final RegistryCenterRepository registryCenterRepository;
    private final ConfigCenterRepository configCenterRepository;
    private final boolean isOverwrite;
    private final ConfigCenter configCenter;
    private final RegistryCenter registryCenter;
    private final ShardingOrchestrationListenerManager listenerManager;

    public ShardingOrchestrationFacade(OrchestrationConfiguration orchestrationConfig, Collection<String> shardingSchemaNames) {
        Optional<String> registryCenterName = this.getInstanceNameByOrchestrationType(orchestrationConfig.getInstanceConfigurationMap(), CenterType.REGISTRY_CENTER.getValue());
        Preconditions.checkArgument((boolean)registryCenterName.isPresent(), (Object)"Can not find instance configuration with registry center orchestration type.");
        CenterConfiguration registryCenterConfiguration = (CenterConfiguration)orchestrationConfig.getInstanceConfigurationMap().get(registryCenterName.get());
        this.registryCenterRepository = new RegistryCenterRepositoryServiceLoader().load(registryCenterConfiguration);
        this.registryCenter = new RegistryCenter(registryCenterName.get(), this.registryCenterRepository);
        Optional<String> configCenterName = this.getInstanceNameByOrchestrationType(orchestrationConfig.getInstanceConfigurationMap(), CenterType.CONFIG_CENTER.getValue());
        Preconditions.checkArgument((boolean)configCenterName.isPresent(), (Object)"Can not find instance configuration with config center orchestration type.");
        CenterConfiguration configCenterConfiguration = (CenterConfiguration)orchestrationConfig.getInstanceConfigurationMap().get(configCenterName.get());
        this.configCenterRepository = new ConfigCenterRepositoryServiceLoader().load(configCenterConfiguration);
        this.isOverwrite = (Boolean)new OrchestrationProperties(configCenterConfiguration.getProperties()).getValue(OrchestrationPropertyKey.OVERWRITE);
        this.configCenter = new ConfigCenter(configCenterName.get(), this.configCenterRepository);
        this.listenerManager = shardingSchemaNames.isEmpty() ? new ShardingOrchestrationListenerManager(registryCenterName.get(), this.registryCenterRepository, configCenterName.get(), this.configCenterRepository, this.configCenter.getAllShardingSchemaNames()) : new ShardingOrchestrationListenerManager(registryCenterName.get(), this.registryCenterRepository, configCenterName.get(), this.configCenterRepository, shardingSchemaNames);
    }

    public void init(Map<String, Map<String, DataSourceConfiguration>> dataSourceConfigurationMap, Map<String, RuleConfiguration> schemaRuleMap, Authentication authentication, Properties props) {
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : dataSourceConfigurationMap.entrySet()) {
            this.configCenter.persistConfiguration(entry.getKey(), dataSourceConfigurationMap.get(entry.getKey()), schemaRuleMap.get(entry.getKey()), authentication, props, this.isOverwrite);
        }
        this.registryCenter.persistInstanceOnline();
        this.registryCenter.persistDataSourcesNode();
        this.listenerManager.initListeners();
    }

    public void init() {
        this.registryCenter.persistInstanceOnline();
        this.registryCenter.persistDataSourcesNode();
        this.listenerManager.initListeners();
    }

    @Override
    public void close() {
        try {
            this.registryCenterRepository.close();
        }
        catch (Exception ex) {
            log.warn("RegCenter exception for: {}", (Object)ex.getMessage());
        }
    }

    private Optional<String> getInstanceNameByOrchestrationType(Map<String, CenterConfiguration> map, String type) {
        return null == map || null == type ? Optional.empty() : map.entrySet().stream().filter(entry -> this.contains(((CenterConfiguration)entry.getValue()).getOrchestrationType(), type)).findFirst().map(Map.Entry::getKey);
    }

    private boolean contains(String collection, String element) {
        return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)collection).stream().anyMatch(each -> element.equals(each.trim()));
    }

    @Generated
    public ConfigCenter getConfigCenter() {
        return this.configCenter;
    }
}

