/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.response;

import com.google.gson.Gson;
import lombok.Generated;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.web.response.ResponseResult;

public final class ResponseResultUtil {
    public static ResponseResult success() {
        return ResponseResultUtil.build(null);
    }

    public static <T> ResponseResult<T> build(T model) {
        ResponseResult<T> result = new ResponseResult<T>();
        result.setSuccess(true);
        result.setModel(model);
        return result;
    }

    public static ResponseResult buildFromJson(String responseResultJson) {
        return (ResponseResult)new Gson().fromJson(responseResultJson, ResponseResult.class);
    }

    public static ResponseResult handleIllegalArgumentException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(400);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public static ResponseResult handleUnauthorizedException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(403);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public static ResponseResult handleShardingSphereUIException(ShardingSphereUIException exception) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(exception.getErrorCode());
        result.setErrorMsg(exception.getMessage());
        return result;
    }

    public static ResponseResult handleUncaughtException(String errorMsg) {
        ResponseResult result = new ResponseResult();
        result.setSuccess(false);
        result.setErrorCode(500);
        result.setErrorMsg(errorMsg);
        return result;
    }

    @Generated
    private ResponseResultUtil() {
    }
}

