/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.Optional;
import org.apache.shardingsphere.ui.common.constant.ForwardServiceType;
import org.apache.shardingsphere.ui.common.domain.ForwardServiceConfig;
import org.apache.shardingsphere.ui.common.domain.ForwardServiceConfigs;
import org.apache.shardingsphere.ui.repository.ForwardServiceConfigsRepository;
import org.apache.shardingsphere.ui.servcie.forward.ShardingScalingForwardService;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shardingscaling"})
public final class ShardingScalingForwardController {
    @Autowired
    private ShardingScalingForwardService shardingScalingForwardService;
    @Autowired
    private ForwardServiceConfigsRepository forwardServiceConfigsRepository;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseResult getService() {
        Optional<ForwardServiceConfig> result = ((ForwardServiceConfigs)this.forwardServiceConfigsRepository.load()).getForwardServiceConfig(ForwardServiceType.SHARDING_SCALING.getName());
        return result.isPresent() ? ResponseResultUtil.build(result.get()) : ResponseResultUtil.handleIllegalArgumentException("No configured sharding scaling services");
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseResult configService(@RequestBody ForwardServiceConfig shardingScalingServiceConfig) {
        ForwardServiceConfigs currentForwardServiceConfig = (ForwardServiceConfigs)this.forwardServiceConfigsRepository.load();
        currentForwardServiceConfig.putForwardServiceConfig(ForwardServiceType.SHARDING_SCALING.getName(), shardingScalingServiceConfig);
        this.forwardServiceConfigsRepository.save(currentForwardServiceConfig);
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ResponseResult deleteService() {
        ForwardServiceConfigs currentForwardServiceConfig = (ForwardServiceConfigs)this.forwardServiceConfigsRepository.load();
        currentForwardServiceConfig.removeForwardServiceConfig(ForwardServiceType.SHARDING_SCALING.getName());
        this.forwardServiceConfigsRepository.save(currentForwardServiceConfig);
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/job/list"}, method={RequestMethod.GET})
    public ResponseResult listAllShardingScalingJobs() {
        return ResponseResultUtil.buildFromJson(this.shardingScalingForwardService.listAllShardingScalingJobs());
    }

    @RequestMapping(value={"/job/start"}, method={RequestMethod.POST})
    public ResponseResult startShardingScalingJob(@RequestBody String requestBody) {
        return ResponseResultUtil.buildFromJson(this.shardingScalingForwardService.startShardingScalingJobs(requestBody));
    }

    @RequestMapping(value={"/job/progress/{jobId}"}, method={RequestMethod.GET})
    public ResponseResult getShardingScalingJobProgress(@PathVariable(value="jobId") int jobId) {
        return ResponseResultUtil.buildFromJson(this.shardingScalingForwardService.getShardingScalingJobProgress(jobId));
    }

    @RequestMapping(value={"/job/stop"}, method={RequestMethod.POST})
    public ResponseResult stopShardingScalingJob(@RequestBody String requestBody) {
        return ResponseResultUtil.buildFromJson(this.shardingScalingForwardService.stopShardingScalingJob(requestBody));
    }
}

