/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class HttpClientUtil {
    private static final String ENCODING = "UTF-8";
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 60000;

    public static String doGet(String url, Map<String, String> headers, Map<String, String> params) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(HttpClientUtil.newInstanceURIBuilder(url, params).build());
            httpGet.setConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build());
            HttpClientUtil.packageHeader(headers, (HttpRequestBase)httpGet);
            String string = HttpClientUtil.getHttpClientResult(httpClient, (HttpRequestBase)httpGet);
            return string;
        }
    }

    public static String doGet(String url, Map<String, String> params) throws IOException, URISyntaxException {
        return HttpClientUtil.doGet(url, null, params);
    }

    public static String doGet(String url) throws IOException, URISyntaxException {
        return HttpClientUtil.doGet(url, null, null);
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build());
            HttpClientUtil.packageHeader(headers, (HttpRequestBase)httpPost);
            HttpClientUtil.packageParam(params, (HttpEntityEnclosingRequestBase)httpPost);
            String string = HttpClientUtil.getHttpClientResult(httpClient, (HttpRequestBase)httpPost);
            return string;
        }
    }

    public static String doPostWithJsonRequestBody(String url, String requestBody) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build());
            httpPost.setHeader("Content-type", "application/json");
            StringEntity requestEntity = new StringEntity(requestBody, ENCODING);
            requestEntity.setContentEncoding(ENCODING);
            httpPost.setEntity((HttpEntity)requestEntity);
            String string = HttpClientUtil.getHttpClientResult(httpClient, (HttpRequestBase)httpPost);
            return string;
        }
    }

    private static URIBuilder newInstanceURIBuilder(String url, Map<String, String> params) throws URISyntaxException {
        URIBuilder result = new URIBuilder(url);
        if (null != params) {
            for (Map.Entry<String, String> each : params.entrySet()) {
                result.setParameter(each.getKey(), each.getValue());
            }
        }
        return result;
    }

    private static void packageHeader(Map<String, String> headers, HttpRequestBase httpMethod) {
        if (null != headers) {
            for (Map.Entry<String, String> each : headers.entrySet()) {
                httpMethod.setHeader(each.getKey(), each.getValue());
            }
        }
    }

    private static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (null != params && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> each : params.entrySet()) {
                nameValuePairs.add(new BasicNameValuePair(each.getKey(), each.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, ENCODING));
        }
    }

    private static String getHttpClientResult(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws IOException {
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpMethod);){
            String string = HttpClientUtil.isValidResponse(httpResponse) ? EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING) : "";
            return string;
        }
    }

    private static boolean isValidResponse(CloseableHttpResponse httpResponse) {
        return null != httpResponse && null != httpResponse.getEntity();
    }
}

