/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.core.yaml.config.common.YamlAuthenticationConfiguration;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.constructor.YamlRootShardingConfigurationConstructor;
import org.apache.shardingsphere.core.yaml.swapper.AuthenticationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.core.configuration.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.yaml.snakeyaml.constructor.Constructor;

public final class ConfigurationYamlConverter {
    public static Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String data) {
        Map result = YamlEngine.unmarshal((String)data);
        Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for orchestration.");
        return Maps.transformValues((Map)result, arg_0 -> ((DataSourceConfigurationYamlSwapper)new DataSourceConfigurationYamlSwapper()).swap(arg_0));
    }

    public static ShardingRuleConfiguration loadShardingRuleConfiguration(String data) {
        return new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)YamlEngine.unmarshal((String)data, YamlShardingRuleConfiguration.class, (Constructor)new YamlRootShardingConfigurationConstructor()));
    }

    public static MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration(String data) {
        return new MasterSlaveRuleConfigurationYamlSwapper().swap((YamlMasterSlaveRuleConfiguration)YamlEngine.unmarshal((String)data, YamlMasterSlaveRuleConfiguration.class));
    }

    public static Authentication loadAuthentication(String data) {
        return new AuthenticationYamlSwapper().swap((YamlAuthenticationConfiguration)YamlEngine.unmarshal((String)data, YamlAuthenticationConfiguration.class));
    }

    public static Properties loadProperties(String data) {
        return YamlEngine.unmarshalProperties((String)data);
    }

    public static EncryptRuleConfiguration loadEncryptRuleConfiguration(String data) {
        return new EncryptRuleConfigurationYamlSwapper().swap((YamlEncryptRuleConfiguration)YamlEngine.unmarshal((String)data, YamlEncryptRuleConfiguration.class));
    }

    @Generated
    private ConfigurationYamlConverter() {
    }
}

