/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.util;

import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.RegistryCenterRepository;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.CuratorZookeeperCenterRepository;
import org.apache.shardingsphere.ui.common.constant.InstanceType;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;

public final class CenterRepositoryFactory {
    private static final ConcurrentHashMap<String, RegistryCenterRepository> REGISTRY_CENTER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ConfigCenterRepository> CONFIG_CENTER_MAP = new ConcurrentHashMap();

    public static RegistryCenterRepository createRegistryCenter(CenterConfig config) {
        RegistryCenterRepository result = REGISTRY_CENTER_MAP.get(config.getName());
        if (null != result) {
            return result;
        }
        InstanceType instanceType = InstanceType.nameOf(config.getInstanceType());
        switch (instanceType) {
            case ZOOKEEPER: {
                result = new CuratorZookeeperCenterRepository();
                break;
            }
            default: {
                throw new UnsupportedOperationException(config.getName());
            }
        }
        result.init(CenterRepositoryFactory.convert(config));
        REGISTRY_CENTER_MAP.put(config.getName(), result);
        return result;
    }

    public static ConfigCenterRepository createConfigCenter(CenterConfig config) {
        ConfigCenterRepository result = CONFIG_CENTER_MAP.get(config.getName());
        if (null != result) {
            return result;
        }
        InstanceType instanceType = InstanceType.nameOf(config.getInstanceType());
        switch (instanceType) {
            case ZOOKEEPER: {
                result = new CuratorZookeeperCenterRepository();
                break;
            }
            default: {
                throw new UnsupportedOperationException(config.getName());
            }
        }
        result.init(CenterRepositoryFactory.convert(config));
        CONFIG_CENTER_MAP.put(config.getName(), result);
        return result;
    }

    private static CenterConfiguration convert(CenterConfig config) {
        CenterConfiguration result = new CenterConfiguration(config.getInstanceType());
        result.setServerLists(config.getServerLists());
        result.setNamespace(config.getNamespace());
        result.getProperties().put("digest", config.getDigest());
        return result;
    }

    @Generated
    private CenterRepositoryFactory() {
    }
}

