/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.ui.servcie.ConfigCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingSchemaService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ShardingSchemaServiceImpl
implements ShardingSchemaService {
    @Autowired
    private ConfigCenterService configCenterService;

    @Override
    public Collection<String> getAllSchemaNames() {
        return this.configCenterService.getActivatedConfigCenter().getChildrenKeys(this.configCenterService.getActivateConfigurationNode().getSchemaPath());
    }

    @Override
    public String getRuleConfiguration(String schemaName) {
        return this.configCenterService.getActivatedConfigCenter().get(this.configCenterService.getActivateConfigurationNode().getRulePath(schemaName));
    }

    @Override
    public String getDataSourceConfiguration(String schemaName) {
        return this.configCenterService.getActivatedConfigCenter().get(this.configCenterService.getActivateConfigurationNode().getDataSourcePath(schemaName));
    }

    @Override
    public void updateRuleConfiguration(String schemaName, String configData) {
        this.checkRuleConfiguration(configData);
        this.persistRuleConfiguration(schemaName, configData);
    }

    @Override
    public void updateDataSourceConfiguration(String schemaName, String configData) {
        this.checkDataSourceConfiguration(configData);
        this.persistDataSourceConfiguration(schemaName, configData);
    }

    @Override
    public void addSchemaConfiguration(String schemaName, String ruleConfiguration, String dataSourceConfiguration) {
        this.checkSchemaName(schemaName, this.getAllSchemaNames());
        this.checkRuleConfiguration(ruleConfiguration);
        this.checkDataSourceConfiguration(dataSourceConfiguration);
        this.persistRuleConfiguration(schemaName, ruleConfiguration);
        this.persistDataSourceConfiguration(schemaName, dataSourceConfiguration);
        this.persistSchemaName(schemaName);
    }

    private void checkRuleConfiguration(String configData) {
        try {
            if (configData.contains("encryptors:\n")) {
                ConfigurationYamlConverter.loadEncryptRuleConfiguration(configData);
            } else if (configData.contains("tables:\n") || configData.contains("defaultTableStrategy:\n")) {
                ConfigurationYamlConverter.loadShardingRuleConfiguration(configData);
            } else {
                ConfigurationYamlConverter.loadMasterSlaveRuleConfiguration(configData);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("rule configuration is invalid.");
        }
    }

    private void persistRuleConfiguration(String schemaName, String ruleConfiguration) {
        this.configCenterService.getActivatedConfigCenter().persist(this.configCenterService.getActivateConfigurationNode().getRulePath(schemaName), ruleConfiguration);
    }

    private void checkDataSourceConfiguration(String configData) {
        try {
            Map<String, DataSourceConfiguration> dataSourceConfigs = ConfigurationYamlConverter.loadDataSourceConfigurations(configData);
            Preconditions.checkState((!dataSourceConfigs.isEmpty() ? 1 : 0) != 0, (Object)"data source configuration is invalid.");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("data source configuration is invalid.");
        }
    }

    private void persistDataSourceConfiguration(String schemaName, String dataSourceConfiguration) {
        this.configCenterService.getActivatedConfigCenter().persist(this.configCenterService.getActivateConfigurationNode().getDataSourcePath(schemaName), dataSourceConfiguration);
    }

    private void checkSchemaName(String schemaName, Collection<String> existedSchemaNames) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (Object)"schema name is invalid.");
        Preconditions.checkArgument((!existedSchemaNames.contains(schemaName) ? 1 : 0) != 0, (Object)"schema name already exists.");
    }

    private void persistSchemaName(String schemaName) {
        ArrayList<String> schemaNameList;
        String schemaPath;
        ConfigCenterRepository configCenterRepository = this.configCenterService.getActivatedConfigCenter();
        String schemaNames = configCenterRepository.get(schemaPath = this.configCenterService.getActivateConfigurationNode().getSchemaPath());
        ArrayList<String> arrayList = schemaNameList = Strings.isNullOrEmpty((String)schemaNames) ? new ArrayList<String>() : new ArrayList(Splitter.on((String)",").splitToList((CharSequence)schemaNames));
        if (!schemaNameList.contains(schemaName)) {
            schemaNameList.add(schemaName);
            configCenterRepository.persist(schemaPath, Joiner.on((String)",").join(schemaNameList));
        }
    }
}

