/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Properties;
import org.apache.shardingsphere.ui.servcie.ConfigCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingPropertiesService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ShardingPropertiesServiceImpl
implements ShardingPropertiesService {
    @Autowired
    private ConfigCenterService configCenterService;

    @Override
    public String loadShardingProperties() {
        return this.configCenterService.getActivatedConfigCenter().get(this.configCenterService.getActivateConfigurationNode().getPropsPath());
    }

    @Override
    public void updateShardingProperties(String configData) {
        this.checkShardingProperties(configData);
        this.configCenterService.getActivatedConfigCenter().persist(this.configCenterService.getActivateConfigurationNode().getPropsPath(), configData);
    }

    private void checkShardingProperties(String configData) {
        try {
            Properties properties = ConfigurationYamlConverter.loadProperties(configData);
            new ConfigurationProperties(properties);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Sharding properties is invalid.");
        }
    }
}

