/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Optional;
import org.apache.shardingsphere.orchestration.center.RegistryCenterRepository;
import org.apache.shardingsphere.orchestration.core.registrycenter.RegistryCenterNode;
import org.apache.shardingsphere.ui.common.constant.OrchestrationType;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.util.CenterRepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class RegistryCenterServiceImpl
implements RegistryCenterService {
    @Autowired
    private CenterConfigService centerConfigService;

    @Override
    public RegistryCenterRepository getActivatedRegistryCenter() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated(OrchestrationType.REGISTRY_CENTER.getValue());
        if (optional.isPresent()) {
            return CenterRepositoryFactory.createRegistryCenter(optional.get());
        }
        throw new ShardingSphereUIException(500, "No activated registry center!");
    }

    @Override
    public RegistryCenterNode getActivatedStateNode() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated(OrchestrationType.REGISTRY_CENTER.getValue());
        if (optional.isPresent()) {
            return new RegistryCenterNode(optional.get().getOrchestrationName());
        }
        throw new ShardingSphereUIException(500, "No activated registry center!");
    }
}

