/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.Optional;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenterNode;
import org.apache.shardingsphere.ui.common.constant.OrchestrationType;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.apache.shardingsphere.ui.servcie.ConfigCenterService;
import org.apache.shardingsphere.ui.util.CenterRepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ConfigCenterServiceImpl
implements ConfigCenterService {
    @Autowired
    private CenterConfigService centerConfigService;

    @Override
    public ConfigCenterRepository getActivatedConfigCenter() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated(OrchestrationType.CONFIG_CENTER.getValue());
        if (optional.isPresent()) {
            return CenterRepositoryFactory.createConfigCenter(optional.get());
        }
        throw new ShardingSphereUIException(500, "No activated config center!");
    }

    @Override
    public ConfigCenterNode getActivateConfigurationNode() {
        Optional<CenterConfig> optional = this.centerConfigService.loadActivated(OrchestrationType.CONFIG_CENTER.getValue());
        if (optional.isPresent()) {
            return new ConfigCenterNode(optional.get().getOrchestrationName());
        }
        throw new ShardingSphereUIException(500, "No activated config center!");
    }
}

