/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.shardingsphere.ui.common.domain.CenterConfig;
import org.apache.shardingsphere.ui.common.domain.CenterConfigs;
import org.apache.shardingsphere.ui.common.dto.CenterConfigDTO;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.repository.CenterConfigsRepository;
import org.apache.shardingsphere.ui.servcie.CenterConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class CenterConfigServiceImpl
implements CenterConfigService {
    @Autowired
    private CenterConfigsRepository centerConfigsRepository;

    @Override
    public CenterConfig load(String name, String orchestrationType) {
        return this.find(name, orchestrationType, this.loadAll());
    }

    @Override
    public Optional<CenterConfig> loadActivated(String orchestrationType) {
        return Optional.ofNullable(this.findActivatedCenterConfiguration(this.loadAll(orchestrationType)));
    }

    @Override
    public void add(CenterConfig config) {
        CenterConfigs configs = this.loadAll();
        CenterConfig existedConfig = this.find(config.getName(), config.getOrchestrationType(), configs);
        if (null != existedConfig) {
            throw new ShardingSphereUIException(500, String.format("Center %s already existed!", config.getName()));
        }
        configs.getCenterConfigs().add(config);
        this.centerConfigsRepository.save(configs);
    }

    @Override
    public void delete(String name, String orchestrationType) {
        CenterConfigs configs = this.loadAll();
        CenterConfig toBeRemovedConfig = this.find(name, orchestrationType, configs);
        if (null != toBeRemovedConfig) {
            configs.getCenterConfigs().remove(toBeRemovedConfig);
            this.centerConfigsRepository.save(configs);
        }
    }

    @Override
    public void setActivated(String name, String orchestrationType) {
        CenterConfigs configs = this.loadAll();
        CenterConfig config = this.find(name, orchestrationType, configs);
        if (null == config) {
            throw new ShardingSphereUIException(500, "Center not existed!");
        }
        CenterConfig activatedConfig = this.findActivatedCenterConfiguration(configs, orchestrationType);
        if (!config.equals(activatedConfig)) {
            if (null != activatedConfig) {
                activatedConfig.setActivated(false);
            }
            config.setActivated(true);
            this.centerConfigsRepository.save(configs);
        }
    }

    @Override
    public CenterConfigs loadAll() {
        return (CenterConfigs)this.centerConfigsRepository.load();
    }

    @Override
    public CenterConfigs loadAll(String orchestrationType) {
        CenterConfigs result = new CenterConfigs();
        ArrayList<CenterConfig> centerConfigs = new ArrayList<CenterConfig>();
        ((CenterConfigs)this.centerConfigsRepository.load()).getCenterConfigs().stream().filter(each -> orchestrationType.equals(each.getOrchestrationType())).forEach(each -> centerConfigs.add((CenterConfig)each));
        result.setCenterConfigs(centerConfigs);
        return result;
    }

    @Override
    public void update(CenterConfigDTO config) {
        CenterConfig existedConfig;
        CenterConfigs configs = this.loadAll();
        if (!config.getPrimaryName().equals(config.getName()) && null != (existedConfig = this.find(config.getName(), config.getOrchestrationType(), configs))) {
            throw new ShardingSphereUIException(500, String.format("Center %s already existed!", config.getName()));
        }
        CenterConfig toBeUpdatedConfig = this.find(config.getPrimaryName(), config.getOrchestrationType(), configs);
        if (null != toBeUpdatedConfig) {
            toBeUpdatedConfig.setName(config.getName());
            toBeUpdatedConfig.setNamespace(config.getNamespace());
            toBeUpdatedConfig.setOrchestrationType(config.getOrchestrationType());
            toBeUpdatedConfig.setInstanceType(config.getInstanceType());
            toBeUpdatedConfig.setServerLists(config.getServerLists());
            toBeUpdatedConfig.setOrchestrationName(config.getOrchestrationName());
            toBeUpdatedConfig.setDigest(config.getDigest());
            this.centerConfigsRepository.save(configs);
        }
    }

    private CenterConfig findActivatedCenterConfiguration(CenterConfigs centerConfigs) {
        return centerConfigs.getCenterConfigs().stream().filter(each -> each.isActivated()).findAny().orElse(null);
    }

    private CenterConfig findActivatedCenterConfiguration(CenterConfigs centerConfigs, String orchestrationType) {
        return centerConfigs.getCenterConfigs().stream().filter(each -> each.isActivated() && orchestrationType.equals(each.getOrchestrationType())).findAny().orElse(null);
    }

    private CenterConfig find(String name, String orchestrationType, CenterConfigs configs) {
        return configs.getCenterConfigs().stream().filter(each -> name.equals(each.getName()) && orchestrationType.equals(each.getOrchestrationType())).findAny().orElse(null);
    }
}

