/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.forward.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.shardingsphere.ui.common.constant.ForwardServiceType;
import org.apache.shardingsphere.ui.common.domain.ForwardServiceConfig;
import org.apache.shardingsphere.ui.common.domain.ForwardServiceConfigs;
import org.apache.shardingsphere.ui.common.exception.ShardingSphereUIException;
import org.apache.shardingsphere.ui.repository.ForwardServiceConfigsRepository;
import org.apache.shardingsphere.ui.servcie.forward.ShardingScalingForwardService;
import org.apache.shardingsphere.ui.util.HttpClientUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ShardingScalingForwardServiceImpl
implements ShardingScalingForwardService {
    private static final String LIST_JOBS_FORWARD_URL = "http://%s/shardingscaling/job/list";
    private static final String START_JOB_FORWARD_URL = "http://%s/shardingscaling/job/start";
    private static final String PROGRESS_JOB_FORWARD_URL = "http://%s/shardingscaling/job/progress/%d";
    private static final String STOP_JOB_FORWARD_URL = "http://%s/shardingscaling/job/stop";
    @Autowired
    private ForwardServiceConfigsRepository forwardServiceConfigsRepository;

    @Override
    public String listAllShardingScalingJobs() {
        try {
            return HttpClientUtil.doGet(String.format(LIST_JOBS_FORWARD_URL, this.getShardingScalingUrl()));
        }
        catch (IOException e) {
            throw this.forwardShardingScalingException();
        }
        catch (URISyntaxException e) {
            throw this.invalidShardingScalingException();
        }
    }

    @Override
    public String startShardingScalingJobs(String requestBody) {
        try {
            return HttpClientUtil.doPostWithJsonRequestBody(String.format(START_JOB_FORWARD_URL, this.getShardingScalingUrl()), requestBody);
        }
        catch (IOException e) {
            throw this.forwardShardingScalingException();
        }
    }

    @Override
    public String getShardingScalingJobProgress(int jobId) {
        try {
            return HttpClientUtil.doGet(String.format(PROGRESS_JOB_FORWARD_URL, this.getShardingScalingUrl(), jobId));
        }
        catch (IOException e) {
            throw this.forwardShardingScalingException();
        }
        catch (URISyntaxException e) {
            throw this.invalidShardingScalingException();
        }
    }

    @Override
    public String stopShardingScalingJob(String requestBody) {
        try {
            return HttpClientUtil.doPostWithJsonRequestBody(String.format(STOP_JOB_FORWARD_URL, this.getShardingScalingUrl()), requestBody);
        }
        catch (IOException e) {
            throw this.forwardShardingScalingException();
        }
    }

    private String getShardingScalingUrl() {
        Optional<ForwardServiceConfig> shardingScalingConfig = ((ForwardServiceConfigs)this.forwardServiceConfigsRepository.load()).getForwardServiceConfig(ForwardServiceType.SHARDING_SCALING.getName());
        if (shardingScalingConfig.isPresent()) {
            return shardingScalingConfig.get().getServiceUrl();
        }
        throw new ShardingSphereUIException(400, "No sharding scaling service configured");
    }

    private ShardingSphereUIException forwardShardingScalingException() {
        return new ShardingSphereUIException(500, "Forward Sharding Scaling Service failed");
    }

    private ShardingSphereUIException invalidShardingScalingException() {
        return new ShardingSphereUIException(400, "Invalid Sharding Scaling Service");
    }
}

