/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.center.instance;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.RegistryCenterRepository;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.ZookeeperProperties;
import org.apache.shardingsphere.orchestration.center.instance.ZookeeperPropertyKey;
import org.apache.shardingsphere.orchestration.center.instance.handler.CuratorZookeeperExceptionHandler;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEventListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class CuratorZookeeperCenterRepository
implements ConfigCenterRepository,
RegistryCenterRepository {
    private final Map<String, TreeCache> caches = new HashMap<String, TreeCache>();
    private CuratorFramework client;
    private Properties properties = new Properties();

    public void init(CenterConfiguration config) {
        ZookeeperProperties zookeeperProperties = new ZookeeperProperties(this.properties);
        this.client = this.buildCuratorClient(config, zookeeperProperties);
        this.initCuratorClient(zookeeperProperties);
    }

    private CuratorFramework buildCuratorClient(CenterConfiguration config, ZookeeperProperties zookeeperProperties) {
        int retryIntervalMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        int maxRetries = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.MAX_RETRIES);
        int timeToLiveSeconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        int operationTimeoutMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS);
        String digest = (String)zookeeperProperties.getValue(ZookeeperPropertyKey.DIGEST);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(config.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries)).namespace(config.getNamespace());
        if (0 != timeToLiveSeconds) {
            builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)digest)) {
            builder.authorization("digest", digest.getBytes(Charsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return builder.build();
    }

    private void initCuratorClient(ZookeeperProperties zookeeperProperties) {
        this.client.start();
        try {
            int retryIntervalMilliseconds = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
            int maxRetries = (Integer)zookeeperProperties.getValue(ZookeeperPropertyKey.MAX_RETRIES);
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public String get(String key) {
        TreeCache cache = this.findTreeCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        ChildData resultInCache = cache.getCurrentData(key);
        if (null != resultInCache) {
            return null == resultInCache.getData() ? null : new String(resultInCache.getData(), Charsets.UTF_8);
        }
        return this.getDirectly(key);
    }

    private TreeCache findTreeCache(String key) {
        return this.caches.entrySet().stream().filter(entry -> key.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(Charsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private void update(String key, String value) {
        try {
            ((CuratorTransactionBridge)((CuratorTransactionBridge)this.client.inTransaction().check().forPath(key)).and().setData().forPath(key, value.getBytes(Charsets.UTF_8))).and().commit();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), Charsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    private boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(Charsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void watch(String key, DataChangedEventListener dataChangedEventListener) {
        String path = key + "/";
        if (!this.caches.containsKey(path)) {
            this.addCacheData(key);
        }
        TreeCache cache = this.caches.get(path);
        cache.getListenable().addListener((client, event) -> {
            ChildData data = event.getData();
            if (null == data || null == data.getPath()) {
                return;
            }
            DataChangedEvent.ChangedType changedType = this.getChangedType(event);
            if (DataChangedEvent.ChangedType.IGNORED != changedType) {
                dataChangedEventListener.onChange(new DataChangedEvent(data.getPath(), null == data.getData() ? null : new String(data.getData(), Charsets.UTF_8), changedType));
            }
        });
    }

    private DataChangedEvent.ChangedType getChangedType(TreeCacheEvent event) {
        switch (event.getType()) {
            case NODE_UPDATED: {
                return DataChangedEvent.ChangedType.UPDATED;
            }
            case NODE_REMOVED: {
                return DataChangedEvent.ChangedType.DELETED;
            }
        }
        return DataChangedEvent.ChangedType.IGNORED;
    }

    private void addCacheData(String cachePath) {
        TreeCache cache = new TreeCache(this.client, cachePath);
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    public void close() {
        this.caches.values().forEach(TreeCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String getType() {
        return "zookeeper";
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

