/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.registrycenter.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.orchestration.core.registrycenter.schema.OrchestrationShardingSchema;

public final class OrchestrationShardingSchemaGroup {
    private final Map<String, Collection<String>> schemaGroup = new HashMap<String, Collection<String>>();

    public void add(OrchestrationShardingSchema orchestrationShardingSchema) {
        String schemaName = orchestrationShardingSchema.getSchemaName();
        if (!this.schemaGroup.containsKey(schemaName)) {
            this.schemaGroup.put(schemaName, new LinkedList());
        }
        this.schemaGroup.get(schemaName).add(orchestrationShardingSchema.getDataSourceName());
    }

    public void put(String shardingSchemaName, Collection<String> dataSourceNames) {
        this.schemaGroup.put(shardingSchemaName, dataSourceNames);
    }

    public Collection<String> getDataSourceNames(String shardingSchemaName) {
        return this.schemaGroup.getOrDefault(shardingSchemaName, Collections.emptyList());
    }
}

