/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.registrycenter.listener;

import org.apache.shardingsphere.orchestration.center.RegistryCenterRepository;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.listener.PostShardingRegistryCenterEventListener;
import org.apache.shardingsphere.orchestration.core.registrycenter.RegistryCenterNode;
import org.apache.shardingsphere.orchestration.core.registrycenter.RegistryCenterNodeStatus;
import org.apache.shardingsphere.orchestration.core.registrycenter.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.core.registrycenter.schema.OrchestrationShardingSchema;

public final class DataSourceStateChangedListener
extends PostShardingRegistryCenterEventListener {
    private final RegistryCenterNode stateNode;

    public DataSourceStateChangedListener(String name, RegistryCenterRepository registryCenterRepository) {
        super(registryCenterRepository, new RegistryCenterNode(name).getDataSourcesNodeFullRootPath());
        this.stateNode = new RegistryCenterNode(name);
    }

    protected DisabledStateChangedEvent createShardingOrchestrationEvent(DataChangedEvent event) {
        return new DisabledStateChangedEvent(this.getShardingSchema(event.getKey()), this.isDataSourceDisabled(event));
    }

    private OrchestrationShardingSchema getShardingSchema(String dataSourceNodeFullPath) {
        return this.stateNode.getOrchestrationShardingSchema(dataSourceNodeFullPath);
    }

    private boolean isDataSourceDisabled(DataChangedEvent event) {
        return RegistryCenterNodeStatus.DISABLED.toString().equalsIgnoreCase(event.getValue()) && DataChangedEvent.ChangedType.UPDATED == event.getChangedType();
    }
}

