/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.registrycenter;

import com.google.common.base.Joiner;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.core.registrycenter.schema.OrchestrationShardingSchema;

public final class RegistryCenterNode {
    private static final String ROOT = "state";
    private static final String INSTANCES_NODE_PATH = "instances";
    private static final String DATA_SOURCES_NODE_PATH = "datasources";
    private final String name;

    public String getInstancesNodeFullPath(String instanceId) {
        return Joiner.on((String)"/").join((Object)"", (Object)this.name, new Object[]{ROOT, INSTANCES_NODE_PATH, instanceId});
    }

    public String getDataSourcesNodeFullRootPath() {
        return Joiner.on((String)"/").join((Object)"", (Object)this.name, new Object[]{ROOT, DATA_SOURCES_NODE_PATH});
    }

    public String getDataSourcesNodeFullPath(String schemaDataSourceName) {
        return Joiner.on((String)"/").join((Object)"", (Object)this.name, new Object[]{ROOT, DATA_SOURCES_NODE_PATH, schemaDataSourceName});
    }

    public OrchestrationShardingSchema getOrchestrationShardingSchema(String dataSourceNodeFullPath) {
        return new OrchestrationShardingSchema(dataSourceNodeFullPath.replace(this.getDataSourcesNodeFullRootPath() + '/', ""));
    }

    @Generated
    public RegistryCenterNode(String name) {
        this.name = name;
    }
}

