/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.configcenter.listener;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.constructor.YamlRootShardingConfigurationConstructor;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.DataSourceChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.EncryptRuleChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.IgnoredShardingOrchestrationEvent;
import org.apache.shardingsphere.orchestration.core.common.event.MasterSlaveRuleChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.SchemaAddedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.SchemaDeletedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.ShardingOrchestrationEvent;
import org.apache.shardingsphere.orchestration.core.common.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.listener.PostShardingConfigCenterEventListener;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenter;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenterNode;
import org.apache.shardingsphere.orchestration.core.configuration.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.core.configuration.YamlDataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.yaml.snakeyaml.constructor.Constructor;

public final class SchemaChangedListener
extends PostShardingConfigCenterEventListener {
    private final ConfigCenter configurationService;
    private final ConfigCenterNode configurationNode;
    private final Collection<String> existedSchemaNames = new LinkedList<String>();

    public SchemaChangedListener(String name, ConfigCenterRepository configCenterRepository, Collection<String> shardingSchemaNames) {
        super(configCenterRepository, new ConfigCenterNode(name).getAllSchemaConfigPaths(shardingSchemaNames));
        this.configurationService = new ConfigCenter(name, configCenterRepository);
        this.configurationNode = new ConfigCenterNode(name);
        this.existedSchemaNames.addAll(shardingSchemaNames);
    }

    protected ShardingOrchestrationEvent createShardingOrchestrationEvent(DataChangedEvent event) {
        if (this.configurationNode.getSchemaPath().equals(event.getKey())) {
            return this.createSchemaNamesUpdatedEvent(event.getValue());
        }
        String shardingSchemaName = this.configurationNode.getSchemaName(event.getKey());
        if (Strings.isNullOrEmpty((String)shardingSchemaName) || !this.isValidNodeChangedEvent(shardingSchemaName, event.getKey())) {
            return new IgnoredShardingOrchestrationEvent();
        }
        if (DataChangedEvent.ChangedType.UPDATED == event.getChangedType()) {
            return this.createUpdatedEvent(shardingSchemaName, event);
        }
        if (DataChangedEvent.ChangedType.DELETED == event.getChangedType()) {
            return this.createDeletedEvent(shardingSchemaName);
        }
        return new IgnoredShardingOrchestrationEvent();
    }

    private ShardingOrchestrationEvent createSchemaNamesUpdatedEvent(String shardingSchemaNames) {
        Collection<String> persistShardingSchemaNames = this.configurationNode.splitShardingSchemaName(shardingSchemaNames);
        SetUtils.SetView addedSchemaNames = SetUtils.difference(new HashSet<String>(persistShardingSchemaNames), new HashSet<String>(this.existedSchemaNames));
        if (!addedSchemaNames.isEmpty()) {
            return this.createUpdatedEventForNewSchema((String)addedSchemaNames.iterator().next());
        }
        SetUtils.SetView deletedSchemaNames = SetUtils.difference(new HashSet<String>(this.existedSchemaNames), new HashSet<String>(persistShardingSchemaNames));
        if (!deletedSchemaNames.isEmpty()) {
            return this.createDeletedEvent((String)deletedSchemaNames.iterator().next());
        }
        return new IgnoredShardingOrchestrationEvent();
    }

    private boolean isValidNodeChangedEvent(String shardingSchemaName, String nodeFullPath) {
        return this.configurationNode.getDataSourcePath(shardingSchemaName).equals(nodeFullPath) || this.configurationNode.getRulePath(shardingSchemaName).equals(nodeFullPath);
    }

    private ShardingOrchestrationEvent createUpdatedEvent(String shardingSchemaName, DataChangedEvent event) {
        return this.existedSchemaNames.contains(shardingSchemaName) ? this.createUpdatedEventForExistedSchema(event, shardingSchemaName) : this.createUpdatedEventForNewSchema(shardingSchemaName);
    }

    private ShardingOrchestrationEvent createUpdatedEventForExistedSchema(DataChangedEvent event, String shardingSchemaName) {
        return event.getKey().equals(this.configurationNode.getDataSourcePath(shardingSchemaName)) ? this.createDataSourceChangedEvent(shardingSchemaName, event) : this.createRuleChangedEvent(shardingSchemaName, event);
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String shardingSchemaName, DataChangedEvent event) {
        Map dataSourceConfigurations = YamlEngine.unmarshal((String)event.getValue());
        Preconditions.checkState((null != dataSourceConfigurations && !dataSourceConfigurations.isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for orchestration.");
        return new DataSourceChangedEvent(shardingSchemaName, dataSourceConfigurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new DataSourceConfigurationYamlSwapper().swap((YamlDataSourceConfiguration)e.getValue()))));
    }

    private ShardingOrchestrationEvent createRuleChangedEvent(String shardingSchemaName, DataChangedEvent event) {
        return this.isEncryptRule(event) ? this.createEncryptRuleChangedEvent(shardingSchemaName, event.getValue()) : (this.isShardingRule(event) ? this.createShardingRuleChangedEvent(shardingSchemaName, event.getValue()) : this.createMasterSlaveRuleChangedEvent(shardingSchemaName, event.getValue()));
    }

    private boolean isShardingRule(DataChangedEvent event) {
        return event.getValue().contains("tables:\n") || event.getValue().contains("tables:\r\n");
    }

    private boolean isEncryptRule(DataChangedEvent event) {
        return event.getValue().contains("encryptors:\n");
    }

    private ShardingRuleChangedEvent createShardingRuleChangedEvent(String shardingSchemaName, String ruleValue) {
        return new ShardingRuleChangedEvent(shardingSchemaName, new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)YamlEngine.unmarshal((String)ruleValue, YamlShardingRuleConfiguration.class, (Constructor)new YamlRootShardingConfigurationConstructor())));
    }

    private EncryptRuleChangedEvent createEncryptRuleChangedEvent(String shardingSchemaName, String ruleValue) {
        return new EncryptRuleChangedEvent(shardingSchemaName, new EncryptRuleConfigurationYamlSwapper().swap((YamlEncryptRuleConfiguration)YamlEngine.unmarshal((String)ruleValue, YamlEncryptRuleConfiguration.class)));
    }

    private MasterSlaveRuleChangedEvent createMasterSlaveRuleChangedEvent(String shardingSchemaName, String ruleValue) {
        return new MasterSlaveRuleChangedEvent(shardingSchemaName, new MasterSlaveRuleConfigurationYamlSwapper().swap((YamlMasterSlaveRuleConfiguration)YamlEngine.unmarshal((String)ruleValue, YamlMasterSlaveRuleConfiguration.class)));
    }

    private ShardingOrchestrationEvent createUpdatedEventForNewSchema(String shardingSchemaName) {
        return this.isOwnCompleteConfigurations(shardingSchemaName) ? this.createSchemaAddedEvent(shardingSchemaName) : new IgnoredShardingOrchestrationEvent();
    }

    private boolean isOwnCompleteConfigurations(String shardingSchemaName) {
        return this.configurationService.hasDataSourceConfiguration(shardingSchemaName) && this.configurationService.hasRuleConfiguration(shardingSchemaName);
    }

    private SchemaAddedEvent createSchemaAddedEvent(String shardingSchemaName) {
        this.existedSchemaNames.add(shardingSchemaName);
        return new SchemaAddedEvent(shardingSchemaName, this.configurationService.loadDataSourceConfigurations(shardingSchemaName), this.createRuleConfiguration(shardingSchemaName));
    }

    private RuleConfiguration createRuleConfiguration(String shardingSchemaName) {
        return this.configurationService.isEncryptRule(shardingSchemaName) ? this.configurationService.loadEncryptRuleConfiguration(shardingSchemaName) : (this.configurationService.isShardingRule(shardingSchemaName) ? this.configurationService.loadShardingRuleConfiguration(shardingSchemaName) : this.configurationService.loadMasterSlaveRuleConfiguration(shardingSchemaName));
    }

    private ShardingOrchestrationEvent createDeletedEvent(String shardingSchemaName) {
        this.existedSchemaNames.remove(shardingSchemaName);
        return new SchemaDeletedEvent(shardingSchemaName);
    }
}

