/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.configcenter.listener;

import java.util.Collection;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.core.configcenter.listener.AuthenticationChangedListener;
import org.apache.shardingsphere.orchestration.core.configcenter.listener.PropertiesChangedListener;
import org.apache.shardingsphere.orchestration.core.configcenter.listener.SchemaChangedListener;

public final class ConfigurationChangedListenerManager {
    private final SchemaChangedListener schemaChangedListener;
    private final PropertiesChangedListener propertiesChangedListener;
    private final AuthenticationChangedListener authenticationChangedListener;

    public ConfigurationChangedListenerManager(String name, ConfigCenterRepository configCenterRepository, Collection<String> shardingSchemaNames) {
        this.schemaChangedListener = new SchemaChangedListener(name, configCenterRepository, shardingSchemaNames);
        this.propertiesChangedListener = new PropertiesChangedListener(name, configCenterRepository);
        this.authenticationChangedListener = new AuthenticationChangedListener(name, configCenterRepository);
    }

    public void initListeners() {
        this.schemaChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED, DataChangedEvent.ChangedType.DELETED});
        this.propertiesChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED});
        this.authenticationChangedListener.watch(new DataChangedEvent.ChangedType[]{DataChangedEvent.ChangedType.UPDATED});
    }
}

