/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.configcenter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ConfigCenterNode {
    private static final String ROOT = "config";
    private static final String SCHEMA_NODE = "schema";
    private static final String DATA_SOURCE_NODE = "datasource";
    private static final String RULE_NODE = "rule";
    private static final String AUTHENTICATION_NODE = "authentication";
    private static final String PROPS_NODE = "props";
    private static final String COMMA_SEPARATOR = ",";
    private static final String PATH_SEPARATOR = "/";
    private final String name;

    public String getSchemaPath() {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)this.name, new Object[]{ROOT, SCHEMA_NODE});
    }

    public String getSchemaNamePath(String schemaName) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)this.name, new Object[]{ROOT, SCHEMA_NODE, schemaName});
    }

    public String getDataSourcePath(String schemaName) {
        return this.getFullPath(schemaName, DATA_SOURCE_NODE);
    }

    public String getRulePath(String schemaName) {
        return this.getFullPath(schemaName, RULE_NODE);
    }

    public String getAuthenticationPath() {
        return this.getFullPath(AUTHENTICATION_NODE);
    }

    public String getPropsPath() {
        return this.getFullPath(PROPS_NODE);
    }

    private String getFullPath(String schemaName, String node) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)this.name, new Object[]{ROOT, SCHEMA_NODE, schemaName, node});
    }

    private String getFullPath(String node) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)"", (Object)this.name, new Object[]{ROOT, node});
    }

    public String getSchemaName(String configurationNodeFullPath) {
        Pattern pattern = Pattern.compile(this.getSchemaPath() + "/(\\w+)(/datasource|/rule)?", 2);
        Matcher matcher = pattern.matcher(configurationNodeFullPath);
        return matcher.find() ? matcher.group(1) : "";
    }

    public Collection<String> splitShardingSchemaName(String shardingSchemaNames) {
        return Strings.isNullOrEmpty((String)shardingSchemaNames) ? Collections.emptyList() : Splitter.on((String)COMMA_SEPARATOR).splitToList((CharSequence)shardingSchemaNames);
    }

    public Collection<String> getAllSchemaConfigPaths(Collection<String> schemaNames) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(this.getSchemaPath()));
        for (String schemaName : schemaNames) {
            result.add(this.getSchemaNamePath(schemaName));
            result.add(this.getRulePath(schemaName));
            result.add(this.getDataSourcePath(schemaName));
        }
        return result;
    }

    @Generated
    public ConfigCenterNode(String name) {
        this.name = name;
    }
}

