/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.configcenter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.shadow.ShadowRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.core.yaml.config.common.YamlAuthenticationConfiguration;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.shadow.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.constructor.YamlRootShardingConfigurationConstructor;
import org.apache.shardingsphere.core.yaml.representer.processor.ShardingTupleProcessorFactory;
import org.apache.shardingsphere.core.yaml.swapper.AuthenticationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShadowRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenterNode;
import org.apache.shardingsphere.orchestration.core.configuration.DataSourceConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.core.configuration.YamlDataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.yaml.snakeyaml.constructor.Constructor;

public final class ConfigCenter {
    private final ConfigCenterNode node;
    private final ConfigCenterRepository repository;

    public ConfigCenter(String name, ConfigCenterRepository configCenterRepository) {
        this.node = new ConfigCenterNode(name);
        this.repository = configCenterRepository;
    }

    public void persistConfiguration(String shardingSchemaName, Map<String, DataSourceConfiguration> dataSourceConfigs, RuleConfiguration ruleConfig, Authentication authentication, Properties props, boolean isOverwrite) {
        this.persistDataSourceConfiguration(shardingSchemaName, dataSourceConfigs, isOverwrite);
        this.persistRuleConfiguration(shardingSchemaName, ruleConfig, isOverwrite);
        this.persistAuthentication(authentication, isOverwrite);
        this.persistProperties(props, isOverwrite);
        this.persistShardingSchemaName(shardingSchemaName);
    }

    private void persistDataSourceConfiguration(String shardingSchemaName, Map<String, DataSourceConfiguration> dataSourceConfigurations, boolean isOverwrite) {
        if (isOverwrite || !this.hasDataSourceConfiguration(shardingSchemaName)) {
            Preconditions.checkState((null != dataSourceConfigurations && !dataSourceConfigurations.isEmpty() ? 1 : 0) != 0, (String)"No available data source in `%s` for orchestration.", (Object[])new Object[]{shardingSchemaName});
            Map<String, YamlDataSourceConfiguration> yamlDataSourceConfigurations = dataSourceConfigurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new DataSourceConfigurationYamlSwapper().swap((DataSourceConfiguration)e.getValue())));
            this.repository.persist(this.node.getDataSourcePath(shardingSchemaName), YamlEngine.marshal(yamlDataSourceConfigurations));
        }
    }

    public boolean hasDataSourceConfiguration(String shardingSchemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getDataSourcePath(shardingSchemaName)));
    }

    private void persistRuleConfiguration(String shardingSchemaName, RuleConfiguration ruleConfig, boolean isOverwrite) {
        if (isOverwrite || !this.hasRuleConfiguration(shardingSchemaName)) {
            if (ruleConfig instanceof ShardingRuleConfiguration) {
                this.persistShardingRuleConfiguration(shardingSchemaName, (ShardingRuleConfiguration)ruleConfig);
            } else if (ruleConfig instanceof EncryptRuleConfiguration) {
                this.persistEncryptRuleConfiguration(shardingSchemaName, (EncryptRuleConfiguration)ruleConfig);
            } else if (ruleConfig instanceof ShadowRuleConfiguration) {
                this.persistShadowRuleConfiguration(shardingSchemaName, (ShadowRuleConfiguration)ruleConfig);
            } else {
                this.persistMasterSlaveRuleConfiguration(shardingSchemaName, (MasterSlaveRuleConfiguration)ruleConfig);
            }
        }
    }

    public boolean hasRuleConfiguration(String shardingSchemaName) {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getRulePath(shardingSchemaName)));
    }

    private void persistShardingRuleConfiguration(String shardingSchemaName, ShardingRuleConfiguration shardingRuleConfiguration) {
        Preconditions.checkState((null != shardingRuleConfiguration && (!shardingRuleConfiguration.getTableRuleConfigs().isEmpty() || shardingRuleConfiguration.getDefaultTableShardingStrategyConfig() != null) ? 1 : 0) != 0, (String)"No available sharding rule configuration in `%s` for orchestration.", (Object[])new Object[]{shardingSchemaName});
        this.repository.persist(this.node.getRulePath(shardingSchemaName), YamlEngine.marshal((Object)new ShardingRuleConfigurationYamlSwapper().swap(shardingRuleConfiguration), (Collection)ShardingTupleProcessorFactory.newInstance()));
    }

    private void persistEncryptRuleConfiguration(String shardingSchemaName, EncryptRuleConfiguration encryptRuleConfiguration) {
        Preconditions.checkState((null != encryptRuleConfiguration && !encryptRuleConfiguration.getEncryptors().isEmpty() ? 1 : 0) != 0, (String)"No available encrypt rule configuration in `%s` for orchestration.", (Object[])new Object[]{shardingSchemaName});
        this.repository.persist(this.node.getRulePath(shardingSchemaName), YamlEngine.marshal((Object)new EncryptRuleConfigurationYamlSwapper().swap(encryptRuleConfiguration)));
    }

    private void persistShadowRuleConfiguration(String shardingSchemaName, ShadowRuleConfiguration shadowRuleConfiguration) {
        Preconditions.checkState((null != shadowRuleConfiguration && !shadowRuleConfiguration.getColumn().isEmpty() && null != shadowRuleConfiguration.getShadowMappings() ? 1 : 0) != 0, (String)"No available shadow rule configuration in `%s` for orchestration.", (Object[])new Object[]{shardingSchemaName});
        this.repository.persist(this.node.getRulePath(shardingSchemaName), YamlEngine.marshal((Object)new ShadowRuleConfigurationYamlSwapper().swap(shadowRuleConfiguration)));
    }

    private void persistMasterSlaveRuleConfiguration(String shardingSchemaName, MasterSlaveRuleConfiguration masterSlaveRuleConfiguration) {
        Preconditions.checkState((null != masterSlaveRuleConfiguration && !masterSlaveRuleConfiguration.getMasterDataSourceName().isEmpty() ? 1 : 0) != 0, (String)"No available master-slave rule configuration in `%s` for orchestration.", (Object[])new Object[]{shardingSchemaName});
        this.repository.persist(this.node.getRulePath(shardingSchemaName), YamlEngine.marshal((Object)new MasterSlaveRuleConfigurationYamlSwapper().swap(masterSlaveRuleConfiguration)));
    }

    private void persistAuthentication(Authentication authentication, boolean isOverwrite) {
        if (null != authentication && (isOverwrite || !this.hasAuthentication())) {
            this.repository.persist(this.node.getAuthenticationPath(), YamlEngine.marshal((Object)new AuthenticationYamlSwapper().swap(authentication)));
        }
    }

    private boolean hasAuthentication() {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getAuthenticationPath()));
    }

    private void persistProperties(Properties props, boolean isOverwrite) {
        if (isOverwrite || !this.hasProperties()) {
            this.repository.persist(this.node.getPropsPath(), YamlEngine.marshal((Object)props));
        }
    }

    private boolean hasProperties() {
        return !Strings.isNullOrEmpty((String)this.repository.get(this.node.getPropsPath()));
    }

    private void persistShardingSchemaName(String shardingSchemaName) {
        String shardingSchemaNames = this.repository.get(this.node.getSchemaPath());
        if (Strings.isNullOrEmpty((String)shardingSchemaNames)) {
            this.repository.persist(this.node.getSchemaPath(), shardingSchemaName);
            return;
        }
        List schemaNameList = Splitter.on((String)",").splitToList((CharSequence)shardingSchemaNames);
        if (schemaNameList.contains(shardingSchemaName)) {
            return;
        }
        ArrayList<String> newArrayList = new ArrayList<String>(schemaNameList);
        newArrayList.add(shardingSchemaName);
        this.repository.persist(this.node.getSchemaPath(), Joiner.on((String)",").join(newArrayList));
    }

    public boolean isShardingRule(String shardingSchemaName) {
        if (this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("encryptRule:\n")) {
            return true;
        }
        if (this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("tables:\n") && !this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("encryptors:\n")) {
            return true;
        }
        return this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("defaultTableStrategy:\n");
    }

    public boolean isEncryptRule(String shardingSchemaName) {
        return !this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("encryptRule:\n") && this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("encryptors:\n");
    }

    public boolean isShadowRule(String shardingSchemaName) {
        return !this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("shadowRule:\n") && this.repository.get(this.node.getRulePath(shardingSchemaName)).contains("shadowMappings:\n");
    }

    public Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String shardingSchemaName) {
        Map result = YamlEngine.unmarshal((String)this.repository.get(this.node.getDataSourcePath(shardingSchemaName)));
        Preconditions.checkState((null != result && !result.isEmpty() ? 1 : 0) != 0, (Object)"No available data sources to load for orchestration.");
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new DataSourceConfigurationYamlSwapper().swap((YamlDataSourceConfiguration)e.getValue())));
    }

    public ShardingRuleConfiguration loadShardingRuleConfiguration(String shardingSchemaName) {
        return new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getRulePath(shardingSchemaName)), YamlShardingRuleConfiguration.class, (Constructor)new YamlRootShardingConfigurationConstructor()));
    }

    public MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration(String shardingSchemaName) {
        return new MasterSlaveRuleConfigurationYamlSwapper().swap((YamlMasterSlaveRuleConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getRulePath(shardingSchemaName)), YamlMasterSlaveRuleConfiguration.class));
    }

    public EncryptRuleConfiguration loadEncryptRuleConfiguration(String shardingSchemaName) {
        return new EncryptRuleConfigurationYamlSwapper().swap((YamlEncryptRuleConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getRulePath(shardingSchemaName)), YamlEncryptRuleConfiguration.class));
    }

    public ShadowRuleConfiguration loadShadowRuleConfiguration(String shardingSchemaName) {
        return new ShadowRuleConfigurationYamlSwapper().swap((YamlShadowRuleConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getRulePath(shardingSchemaName)), YamlShadowRuleConfiguration.class));
    }

    public Authentication loadAuthentication() {
        return new AuthenticationYamlSwapper().swap((YamlAuthenticationConfiguration)YamlEngine.unmarshal((String)this.repository.get(this.node.getAuthenticationPath()), YamlAuthenticationConfiguration.class));
    }

    public Properties loadProperties() {
        return YamlEngine.unmarshalProperties((String)this.repository.get(this.node.getPropsPath()));
    }

    public Collection<String> getAllShardingSchemaNames() {
        String shardingSchemaNames = this.repository.get(this.node.getSchemaPath());
        return this.node.splitShardingSchemaName(shardingSchemaNames);
    }
}

