/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.strategy.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;

public final class AESEncryptor
implements Encryptor {
    private static final String AES_KEY = "aes.key.value";
    private Properties properties = new Properties();

    public String getType() {
        return "AES";
    }

    @Override
    public void init() {
    }

    @Override
    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(StringUtils.getBytesUtf8((String)String.valueOf(plaintext)));
        return Base64.encodeBase64String((byte[])result);
    }

    @Override
    public Object decrypt(String ciphertext) {
        if (null == ciphertext) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(Base64.decodeBase64((String)ciphertext));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Preconditions.checkArgument((boolean)this.properties.containsKey(AES_KEY), (String)"No available secret key for `%s`.", (Object[])new Object[]{AESEncryptor.class.getName()});
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.createSecretKey(), this.getType()));
        return result;
    }

    private byte[] createSecretKey() {
        Preconditions.checkArgument((null != this.properties.get(AES_KEY) ? 1 : 0) != 0, (Object)String.format("%s can not be null.", AES_KEY));
        return Arrays.copyOf(DigestUtils.sha1((String)this.properties.get(AES_KEY).toString()), 16);
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

