/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptorRuleConfiguration;
import org.apache.shardingsphere.encrypt.strategy.EncryptTable;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;
import org.apache.shardingsphere.encrypt.strategy.spi.QueryAssistedEncryptor;
import org.apache.shardingsphere.encrypt.strategy.spi.loader.EncryptorServiceLoader;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;

public final class EncryptRule
implements BaseRule {
    private final Map<String, Encryptor> encryptors = new LinkedHashMap<String, Encryptor>();
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private EncryptRuleConfiguration ruleConfiguration;

    public EncryptRule() {
        this.ruleConfiguration = new EncryptRuleConfiguration();
    }

    public EncryptRule(EncryptRuleConfiguration encryptRuleConfig) {
        this.ruleConfiguration = encryptRuleConfig;
        Preconditions.checkArgument((boolean)this.isValidRuleConfiguration(), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        this.initEncryptors(encryptRuleConfig.getEncryptors());
        this.initTables(encryptRuleConfig.getTables());
    }

    private boolean isValidRuleConfiguration() {
        return this.ruleConfiguration.getEncryptors().isEmpty() && this.ruleConfiguration.getTables().isEmpty() || this.isValidTableConfiguration();
    }

    private boolean isValidTableConfiguration() {
        for (EncryptTableRuleConfiguration table : this.ruleConfiguration.getTables().values()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns().values()) {
                if (this.isValidColumnConfiguration(column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfiguration(EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptor()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && this.ruleConfiguration.getEncryptors().containsKey(column.getEncryptor());
    }

    private void initEncryptors(Map<String, EncryptorRuleConfiguration> encryptors) {
        EncryptorServiceLoader serviceLoader = new EncryptorServiceLoader();
        for (Map.Entry<String, EncryptorRuleConfiguration> entry : encryptors.entrySet()) {
            this.encryptors.put(entry.getKey(), this.createEncryptor(serviceLoader, entry.getValue()));
        }
    }

    private Encryptor createEncryptor(EncryptorServiceLoader serviceLoader, EncryptorRuleConfiguration encryptorRuleConfig) {
        Encryptor result = (Encryptor)serviceLoader.newService(encryptorRuleConfig.getType(), encryptorRuleConfig.getProperties());
        result.init();
        return result;
    }

    private void initTables(Map<String, EncryptTableRuleConfiguration> tables) {
        for (Map.Entry<String, EncryptTableRuleConfiguration> entry : tables.entrySet()) {
            this.tables.put(entry.getKey(), new EncryptTable(entry.getValue()));
        }
    }

    public Optional<EncryptTable> findEncryptTable(String logicTable) {
        return Optional.ofNullable(this.tables.get(logicTable));
    }

    public String getLogicColumnOfCipher(String logicTable, String cipherColumn) {
        return this.tables.get(logicTable).getLogicColumnOfCipher(cipherColumn);
    }

    public Optional<String> findPlainColumn(String logicTable, String logicColumn) {
        Optional<String> originColumnName = this.findOriginColumnName(logicTable, logicColumn);
        return originColumnName.isPresent() && this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findPlainColumn(originColumnName.get()) : Optional.empty();
    }

    private Optional<String> findOriginColumnName(String logicTable, String logicColumn) {
        for (String each : this.tables.get(logicTable).getLogicColumns()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public String getCipherColumn(String logicTable, String logicColumn) {
        return this.tables.get(logicTable).getCipherColumn(logicColumn);
    }

    public boolean isCipherColumn(String tableName, String columnName) {
        return this.tables.containsKey(tableName) && this.tables.get(tableName).getCipherColumns().contains(columnName);
    }

    public Optional<String> findAssistedQueryColumn(String logicTable, String logicColumn) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findAssistedQueryColumn(logicColumn) : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getAssistedQueryColumns() : Collections.emptyList();
    }

    public Collection<String> getAssistedQueryAndPlainColumns(String logicTable) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.getAssistedQueryColumns(logicTable));
        result.addAll(this.getPlainColumns(logicTable));
        return result;
    }

    private Collection<String> getPlainColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getPlainColumns() : Collections.emptyList();
    }

    public Map<String, String> getLogicAndCipherColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getLogicAndCipherColumns() : Collections.emptyMap();
    }

    public Map<String, String> getLogicAndPlainColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getLogicAndPlainColumns() : Collections.emptyMap();
    }

    public List<Object> getEncryptAssistedQueryValues(String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<Encryptor> encryptor = this.findEncryptor(logicTable, logicColumn);
        Preconditions.checkArgument((encryptor.isPresent() && encryptor.get() instanceof QueryAssistedEncryptor ? 1 : 0) != 0, (Object)String.format("Can not find QueryAssistedEncryptor by %s.%s.", logicTable, logicColumn));
        return originalValues.stream().map(input -> null == input ? null : ((QueryAssistedEncryptor)encryptor.get()).queryAssistedEncrypt(input.toString())).collect(Collectors.toList());
    }

    public List<Object> getEncryptValues(String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<Encryptor> encryptor = this.findEncryptor(logicTable, logicColumn);
        Preconditions.checkArgument((boolean)encryptor.isPresent(), (Object)String.format("Can not find QueryAssistedEncryptor by %s.%s.", logicTable, logicColumn));
        return originalValues.stream().map(input -> null == input ? null : String.valueOf(((Encryptor)encryptor.get()).encrypt(input.toString()))).collect(Collectors.toList());
    }

    public Optional<Encryptor> findEncryptor(String logicTable, String logicColumn) {
        if (!this.tables.containsKey(logicTable)) {
            return Optional.empty();
        }
        Optional<String> encryptor = this.tables.get(logicTable).findEncryptor(logicColumn);
        return encryptor.map(this.encryptors::get);
    }

    public Collection<String> getEncryptTableNames() {
        return this.tables.keySet();
    }

    @Generated
    public EncryptRuleConfiguration getRuleConfiguration() {
        return this.ruleConfiguration;
    }
}

