/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.common.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;

public final class OrchestrationMasterSlaveRule
extends MasterSlaveRule {
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public OrchestrationMasterSlaveRule(MasterSlaveRuleConfiguration masterSlaveRuleConfig) {
        super(masterSlaveRuleConfig);
    }

    public List<String> getSlaveDataSourceNames() {
        return super.getSlaveDataSourceNames().stream().filter(e -> !this.disabledDataSourceNames.contains(e)).collect(Collectors.toList());
    }

    public void updateDisabledDataSourceNames(String dataSourceName, boolean isDisabled) {
        if (isDisabled) {
            this.disabledDataSourceNames.add(dataSourceName);
        } else {
            this.disabledDataSourceNames.remove(dataSourceName);
        }
    }

    @Generated
    public Collection<String> getDisabledDataSourceNames() {
        return this.disabledDataSourceNames;
    }
}

