/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.core.common.listener;

import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.ShardingOrchestrationEvent;
import org.apache.shardingsphere.orchestration.core.common.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.core.common.listener.ShardingOrchestrationListener;

public abstract class PostShardingConfigCenterEventListener
implements ShardingOrchestrationListener {
    private final EventBus eventBus = ShardingOrchestrationEventBus.getInstance();
    private final ConfigCenterRepository configCenterRepository;
    private final Collection<String> watchKeys;

    @Override
    public final void watch(DataChangedEvent.ChangedType ... watchedChangedTypes) {
        List<DataChangedEvent.ChangedType> watchedChangedTypeList = Arrays.asList(watchedChangedTypes);
        for (String watchKey : this.watchKeys) {
            this.watch(watchKey, watchedChangedTypeList);
        }
    }

    private void watch(String watchKey, Collection<DataChangedEvent.ChangedType> watchedChangedTypeList) {
        this.configCenterRepository.watch(watchKey, dataChangedEvent -> {
            if (watchedChangedTypeList.contains(dataChangedEvent.getChangedType())) {
                this.eventBus.post((Object)this.createShardingOrchestrationEvent(dataChangedEvent));
            }
        });
    }

    protected abstract ShardingOrchestrationEvent createShardingOrchestrationEvent(DataChangedEvent var1);

    @Generated
    public PostShardingConfigCenterEventListener(ConfigCenterRepository configCenterRepository, Collection<String> watchKeys) {
        this.configCenterRepository = configCenterRepository;
        this.watchKeys = watchKeys;
    }
}

